/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test.jupiter;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.StringMangler;
import org.eclipse.jetty.toolchain.test.URLEncode;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class WorkDirExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    public void beforeAll(ExtensionContext context) {
        this.injectStaticFields(context, context.getRequiredTestClass());
    }

    public void beforeEach(ExtensionContext context) {
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> this.injectInstanceFields(context, instance));
    }

    private void injectStaticFields(ExtensionContext context, Class<?> testClass) {
        this.injectFields(context, null, testClass, ReflectionUtils::isStatic);
    }

    private void injectInstanceFields(ExtensionContext context, Object instance) {
        this.injectFields(context, instance, instance.getClass(), ReflectionUtils::isNotStatic);
    }

    private void injectFields(ExtensionContext context, Object testInstance, Class<?> testClass, Predicate<Field> fieldPredicate) {
        if (!context.getTestInstance().isPresent()) {
            return;
        }
        try {
            Object obj = context.getTestInstance().get();
            Path testPath = this.toPath(obj.getClass(), context);
            WorkDir workdir = new WorkDir(testPath);
            Predicate<Field> isWorkDirAssignable = f -> WorkDir.class.isAssignableFrom(f.getType());
            ReflectionUtils.findFields(testClass, fieldPredicate.and(isWorkDirAssignable), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).forEach(field -> {
                this.assertValidFieldCandidate((Field)field);
                try {
                    ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(testInstance, workdir);
                }
                catch (Throwable t) {
                    ExceptionUtils.throwAsUncheckedException((Throwable)t);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to establish WorkDir path", e);
        }
    }

    private void assertValidFieldCandidate(Field field) {
        if (ReflectionUtils.isPrivate((Member)field)) {
            throw new ExtensionConfigurationException("WorkDir field [" + field + "] must not be private.");
        }
    }

    private Path toPath(Class<?> classContext, ExtensionContext context) throws IOException {
        StringBuilder dirName = new StringBuilder();
        Class<?> clazz = context.getTestClass().orElse(classContext);
        dirName.append(StringMangler.condensePackageString(clazz.getName()));
        dirName.append(File.separatorChar);
        if (context.getTestMethod().isPresent()) {
            String methodname = ((Method)context.getTestMethod().get()).getName();
            if (OS.WINDOWS.isCurrentOs()) {
                dirName.append(StringMangler.maxStringLength(30, methodname));
            } else {
                dirName.append(methodname);
            }
            if (!context.getDisplayName().startsWith(methodname)) {
                dirName.append(URLEncode.encode(context.getDisplayName().trim(), StandardCharsets.UTF_8.toString()));
            }
        } else {
            dirName.append(URLEncode.encode(context.getDisplayName().trim(), StandardCharsets.UTF_8.toString()));
        }
        return MavenTestingUtils.getTargetTestingPath().resolve(dirName.toString());
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return WorkDir.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        try {
            Path dir = this.toPath(parameterContext.getDeclaringExecutable().getDeclaringClass(), extensionContext);
            return new WorkDir(dir);
        }
        catch (IOException e) {
            throw new ParameterResolutionException("Unable to resolve work dir", (Throwable)e);
        }
    }
}

