/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AppenderAttachableImplTest {
    private AppenderAttachableImpl<TestEvent> aai;

    @Before
    public void setUp() throws Exception {
        this.aai = new AppenderAttachableImpl();
    }

    @After
    public void tearDown() throws Exception {
        this.aai = null;
    }

    @Test
    public void testAddAppender() throws Exception {
        TestEvent event = new TestEvent();
        NOPAppender ta = new NOPAppender();
        ta.start();
        this.aai.addAppender((Appender)ta);
        ta = new NOPAppender();
        ta.setName("test");
        ta.start();
        this.aai.addAppender((Appender)ta);
        int size = this.aai.appendLoopOnAppenders((Object)event);
        Assert.assertTrue((String)"Incorrect number of appenders", (size == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testIteratorForAppenders() throws Exception {
        NOPAppender ta = new NOPAppender();
        ta.start();
        this.aai.addAppender((Appender)ta);
        NOPAppender tab = new NOPAppender();
        tab.setName("test");
        tab.start();
        this.aai.addAppender((Appender)tab);
        Iterator iter = this.aai.iteratorForAppenders();
        int size = 0;
        while (iter.hasNext()) {
            ++size;
            Appender app = (Appender)iter.next();
            Assert.assertTrue((String)"Bad Appender", (app == ta || app == tab ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"Incorrect number of appenders", (size == 2 ? 1 : 0) != 0);
    }

    @Test
    public void getGetAppender() throws Exception {
        NOPAppender test = new NOPAppender();
        test.setName("test");
        test.start();
        this.aai.addAppender((Appender)test);
        NOPAppender testOther = new NOPAppender();
        testOther.setName("testOther");
        testOther.start();
        this.aai.addAppender((Appender)testOther);
        Appender a = this.aai.getAppender("testOther");
        Assert.assertNotNull((String)"Could not find appender", (Object)a);
        Assert.assertTrue((String)"Wrong appender", (a == testOther ? 1 : 0) != 0);
        a = this.aai.getAppender("test");
        Assert.assertNotNull((String)"Could not find appender", (Object)a);
        Assert.assertTrue((String)"Wrong appender", (a == test ? 1 : 0) != 0);
        a = this.aai.getAppender("NotThere");
        Assert.assertNull((String)"Appender was returned", (Object)a);
    }

    @Test
    public void testIsAttached() throws Exception {
        NOPAppender ta = new NOPAppender();
        ta.start();
        this.aai.addAppender((Appender)ta);
        NOPAppender tab = new NOPAppender();
        tab.setName("test");
        tab.start();
        this.aai.addAppender((Appender)tab);
        Assert.assertTrue((String)"Appender is not attached", (boolean)this.aai.isAttached((Appender)ta));
        Assert.assertTrue((String)"Appender is not attached", (boolean)this.aai.isAttached((Appender)tab));
    }

    @Test
    public void testDetachAndStopAllAppenders() throws Exception {
        NOPAppender ta = new NOPAppender();
        ta.start();
        this.aai.addAppender((Appender)ta);
        NOPAppender tab = new NOPAppender();
        tab.setName("test");
        tab.start();
        this.aai.addAppender((Appender)tab);
        Assert.assertTrue((String)"Appender was not started", (boolean)tab.isStarted());
        this.aai.detachAndStopAllAppenders();
        Assert.assertNull((String)"Appender was not removed", (Object)this.aai.getAppender("test"));
        Assert.assertFalse((String)"Appender was not stopped", (boolean)tab.isStarted());
    }

    @Test
    public void testDetachAppender() throws Exception {
        NOPAppender ta = new NOPAppender();
        ta.start();
        this.aai.addAppender((Appender)ta);
        NOPAppender tab = new NOPAppender();
        tab.setName("test");
        tab.start();
        this.aai.addAppender((Appender)tab);
        Assert.assertTrue((String)"Appender not detached", (boolean)this.aai.detachAppender((Appender)tab));
        Assert.assertNull((String)"Appender was not removed", (Object)this.aai.getAppender("test"));
        Assert.assertFalse((String)"Appender detach error", (boolean)this.aai.detachAppender((Appender)tab));
    }

    @Test
    public void testDetachAppenderByName() throws Exception {
        NOPAppender ta = new NOPAppender();
        ta.setName("test1");
        ta.start();
        this.aai.addAppender((Appender)ta);
        NOPAppender tab = new NOPAppender();
        tab.setName("test");
        tab.start();
        this.aai.addAppender((Appender)tab);
        Assert.assertTrue((boolean)this.aai.detachAppender("test"));
        Assert.assertTrue((boolean)this.aai.detachAppender("test1"));
        Assert.assertFalse((boolean)this.aai.detachAppender("test1"));
    }

    private static class TestEvent {
        private TestEvent() {
        }
    }
}

