/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;

public class ShouldContainCharSequenceOnlyOnce
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContainOnlyOnce(CharSequence actual, CharSequence sequence, int occurences, ComparisonStrategy comparisonStrategy) {
        if (occurences == 0) {
            return new ShouldContainCharSequenceOnlyOnce(actual, sequence, comparisonStrategy);
        }
        return new ShouldContainCharSequenceOnlyOnce(actual, sequence, occurences, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContainOnlyOnce(CharSequence actual, CharSequence sequence, int occurences) {
        if (occurences == 0) {
            return new ShouldContainCharSequenceOnlyOnce(actual, sequence, StandardComparisonStrategy.instance());
        }
        return new ShouldContainCharSequenceOnlyOnce(actual, sequence, occurences, StandardComparisonStrategy.instance());
    }

    private ShouldContainCharSequenceOnlyOnce(CharSequence actual, CharSequence expected, int occurences, ComparisonStrategy comparisonStrategy) {
        super("\nExpecting:\n <%s>\nto appear only once in:\n <%s>\nbut it appeared %s times %s", expected, actual, occurences, comparisonStrategy);
    }

    private ShouldContainCharSequenceOnlyOnce(CharSequence actual, CharSequence expected, ComparisonStrategy comparisonStrategy) {
        super("\nExpecting:\n <%s>\nto appear only once in:\n <%s>\nbut it did not appear %s", expected, actual, comparisonStrategy);
    }
}

