/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal;

import java.lang.reflect.Field;
import nl.jqno.equalsverifier.internal.FieldAccessor;
import nl.jqno.equalsverifier.internal.FieldIterable;
import nl.jqno.equalsverifier.internal.Instantiator;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;

public final class ObjectAccessor<T> {
    private final T object;
    private final Class<T> type;

    private ObjectAccessor(T object, Class<T> type) {
        this.object = object;
        this.type = type;
    }

    public static <T> ObjectAccessor<T> of(T object) {
        Class<?> type = object.getClass();
        return new ObjectAccessor<T>(object, type);
    }

    public static <T> ObjectAccessor<T> of(T object, Class<T> type) {
        return new ObjectAccessor<T>(object, type);
    }

    public T get() {
        return this.object;
    }

    public FieldAccessor fieldAccessorFor(Field field) {
        return new FieldAccessor(this.object, field);
    }

    public T copy() {
        T copy = Instantiator.of(this.type).instantiate();
        return this.copyInto(copy);
    }

    public <S extends T> S copyIntoSubclass(Class<S> subclass) {
        S copy = Instantiator.of(subclass).instantiate();
        return this.copyInto(copy);
    }

    public T copyIntoAnonymousSubclass() {
        T copy = Instantiator.of(this.type).instantiateAnonymousSubclass();
        return this.copyInto(copy);
    }

    private <S> S copyInto(S copy) {
        for (Field field : FieldIterable.of(this.type)) {
            FieldAccessor accessor = new FieldAccessor(this.object, field);
            accessor.copyTo(copy);
        }
        return copy;
    }

    public void scramble(PrefabValues prefabValues, TypeTag enclosingType) {
        for (Field field : FieldIterable.of(this.type)) {
            FieldAccessor accessor = new FieldAccessor(this.object, field);
            accessor.changeField(prefabValues, enclosingType);
        }
    }

    public void shallowScramble(PrefabValues prefabValues, TypeTag enclosingType) {
        for (Field field : FieldIterable.ofIgnoringSuper(this.type)) {
            FieldAccessor accessor = new FieldAccessor(this.object, field);
            accessor.changeField(prefabValues, enclosingType);
        }
    }
}

