/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation;

import java.lang.reflect.Type;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.modifier.ModifierContributor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDefinition;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.TargetType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.InstrumentedType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.ByteCodeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.FieldAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodReturn;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;

public abstract class FieldAccessor
implements Implementation {
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected FieldAccessor(Assigner assigner, Assigner.Typing typing) {
        this.assigner = assigner;
        this.typing = typing;
    }

    public static FieldDefinable ofField(String name) {
        return new ForNamedField(Assigner.DEFAULT, Assigner.Typing.STATIC, name);
    }

    public static OwnerTypeLocatable ofBeanProperty() {
        return FieldAccessor.of(FieldNameExtractor.ForBeanProperty.INSTANCE);
    }

    public static OwnerTypeLocatable of(FieldNameExtractor fieldNameExtractor) {
        return new ForUnnamedField(Assigner.DEFAULT, Assigner.Typing.STATIC, fieldNameExtractor);
    }

    protected ByteCodeAppender.Size applyGetter(MethodVisitor methodVisitor, Implementation.Context implementationContext, FieldDescription fieldDescription, MethodDescription methodDescription) {
        StackManipulation stackManipulation = this.assigner.assign(fieldDescription.getType(), methodDescription.getReturnType(), this.typing);
        if (!stackManipulation.isValid()) {
            throw new IllegalStateException("Getter type of " + methodDescription + " is not compatible with " + fieldDescription);
        }
        return this.apply(methodVisitor, implementationContext, fieldDescription, methodDescription, new StackManipulation.Compound(FieldAccess.forField(fieldDescription).getter(), stackManipulation));
    }

    protected ByteCodeAppender.Size applySetter(MethodVisitor methodVisitor, Implementation.Context implementationContext, FieldDescription fieldDescription, MethodDescription methodDescription) {
        StackManipulation stackManipulation = this.assigner.assign(((ParameterDescription)methodDescription.getParameters().get(0)).getType(), fieldDescription.getType(), this.typing);
        if (!stackManipulation.isValid()) {
            throw new IllegalStateException("Setter type of " + methodDescription + " is not compatible with " + fieldDescription);
        }
        if (fieldDescription.isFinal()) {
            throw new IllegalArgumentException("Cannot apply setter on final field " + fieldDescription);
        }
        return this.apply(methodVisitor, implementationContext, fieldDescription, methodDescription, new StackManipulation.Compound(MethodVariableAccess.of(fieldDescription.getType().asErasure()).loadOffset(((ParameterDescription)methodDescription.getParameters().get(0)).getOffset()), stackManipulation, FieldAccess.forField(fieldDescription).putter()));
    }

    private ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, FieldDescription fieldDescription, MethodDescription methodDescription, StackManipulation fieldAccess) {
        if (methodDescription.isStatic() && !fieldDescription.isStatic()) {
            throw new IllegalArgumentException("Cannot call instance field " + fieldDescription + " from static method " + methodDescription);
        }
        StackManipulation.Size stackSize = new StackManipulation.Compound(fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.REFERENCE.loadOffset(0), fieldAccess, MethodReturn.returning(methodDescription.getReturnType().asErasure())).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), methodDescription.getStackSize());
    }

    protected abstract String getFieldName(MethodDescription var1);

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.typing == ((FieldAccessor)other).typing && this.assigner.equals(((FieldAccessor)other).assigner);
    }

    public int hashCode() {
        return 31 * this.assigner.hashCode() + this.typing.hashCode();
    }

    protected class Appender
    implements ByteCodeAppender {
        private final FieldLocator fieldLocator;

        protected Appender(FieldLocator fieldLocator) {
            this.fieldLocator = fieldLocator;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            if (ElementMatchers.isConstructor().matches(instrumentedMethod)) {
                throw new IllegalArgumentException("Constructors cannot define beans: " + instrumentedMethod);
            }
            if (ElementMatchers.takesArguments(0).and(ElementMatchers.not(ElementMatchers.returns(Void.TYPE))).matches(instrumentedMethod)) {
                return FieldAccessor.this.applyGetter(methodVisitor, implementationContext, this.fieldLocator.locate(FieldAccessor.this.getFieldName(instrumentedMethod), instrumentedMethod.isStatic()), instrumentedMethod);
            }
            if (ElementMatchers.takesArguments(1).and(ElementMatchers.returns(Void.TYPE)).matches(instrumentedMethod)) {
                return FieldAccessor.this.applySetter(methodVisitor, implementationContext, this.fieldLocator.locate(FieldAccessor.this.getFieldName(instrumentedMethod), instrumentedMethod.isStatic()), instrumentedMethod);
            }
            throw new IllegalArgumentException("Method " + implementationContext + " is no bean property");
        }

        private FieldAccessor getFieldAccessor() {
            return FieldAccessor.this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.fieldLocator.equals(((Appender)other).fieldLocator) && FieldAccessor.this.equals(((Appender)other).getFieldAccessor());
        }

        public int hashCode() {
            return 31 * FieldAccessor.this.hashCode() + this.fieldLocator.hashCode();
        }

        public String toString() {
            return "FieldAccessor.Appender{fieldLocator=" + this.fieldLocator + "fieldAccessor=" + FieldAccessor.this + '}';
        }
    }

    protected static class ForNamedField
    extends FieldAccessor
    implements FieldDefinable {
        private final String fieldName;
        private final PreparationHandler preparationHandler;
        private final FieldLocator.Factory fieldLocatorFactory;

        protected ForNamedField(Assigner assigner, Assigner.Typing typing, String fieldName) {
            super(assigner, typing);
            this.fieldName = fieldName;
            this.preparationHandler = PreparationHandler.NoOp.INSTANCE;
            this.fieldLocatorFactory = FieldLocator.ForInstrumentedTypeHierarchy.Factory.INSTANCE;
        }

        private ForNamedField(Assigner assigner, Assigner.Typing typing, String fieldName, PreparationHandler preparationHandler, FieldLocator.Factory fieldLocatorFactory) {
            super(assigner, typing);
            this.fieldName = fieldName;
            this.preparationHandler = preparationHandler;
            this.fieldLocatorFactory = fieldLocatorFactory;
        }

        @Override
        public AssignerConfigurable defineAs(Type type, ModifierContributor.ForField ... modifier) {
            return this.defineAs(TypeDefinition.Sort.describe(type), modifier);
        }

        @Override
        public AssignerConfigurable defineAs(TypeDefinition typeDefinition, ModifierContributor.ForField ... modifier) {
            return new ForNamedField(this.assigner, this.typing, this.fieldName, PreparationHandler.FieldDefiner.of(this.fieldName, typeDefinition.asGenericType(), modifier), FieldLocator.ForInstrumentedType.INSTANCE);
        }

        @Override
        public AssignerConfigurable in(FieldLocator.Factory fieldLocatorFactory) {
            return new ForNamedField(this.assigner, this.typing, this.fieldName, this.preparationHandler, fieldLocatorFactory);
        }

        @Override
        public AssignerConfigurable in(Class<?> type) {
            return this.in(new TypeDescription.ForLoadedType(type));
        }

        @Override
        public AssignerConfigurable in(TypeDescription typeDescription) {
            return typeDescription.represents((Type)((Object)TargetType.class)) ? this.in(FieldLocator.ForInstrumentedType.INSTANCE) : this.in(new FieldLocator.ForGivenType.Factory(typeDescription));
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForNamedField(assigner, typing, this.fieldName, this.preparationHandler, this.fieldLocatorFactory);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return this.preparationHandler.prepare(instrumentedType);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(this.fieldLocatorFactory.make(implementationTarget.getInstrumentedType()));
        }

        @Override
        protected String getFieldName(MethodDescription targetMethod) {
            return this.fieldName;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            if (!super.equals(other)) {
                return false;
            }
            ForNamedField that = (ForNamedField)other;
            return this.fieldLocatorFactory.equals(that.fieldLocatorFactory) && this.fieldName.equals(that.fieldName) && this.preparationHandler.equals(that.preparationHandler);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.fieldName.hashCode();
            result = 31 * result + this.preparationHandler.hashCode();
            result = 31 * result + this.fieldLocatorFactory.hashCode();
            return result;
        }

        public String toString() {
            return "FieldAccessor.ForNamedField{assigner=" + this.assigner + ", fieldName='" + this.fieldName + '\'' + ", typing=" + (Object)((Object)this.typing) + ", preparationHandler=" + this.preparationHandler + ", fieldLocatorFactory=" + this.fieldLocatorFactory + '}';
        }

        protected static interface PreparationHandler {
            public InstrumentedType prepare(InstrumentedType var1);

            public static class FieldDefiner
            implements PreparationHandler {
                private final String name;
                private final TypeDescription.Generic typeDescription;
                private final int modifiers;

                protected FieldDefiner(String name, TypeDescription.Generic typeDescription, int modifiers) {
                    this.name = name;
                    this.typeDescription = typeDescription;
                    this.modifiers = modifiers;
                }

                public static PreparationHandler of(String name, TypeDescription.Generic typeDescription, ModifierContributor.ForField ... contributor) {
                    return new FieldDefiner(name, typeDescription, ModifierContributor.Resolver.of(contributor).resolve());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    if (instrumentedType.isInterface() && ((this.modifiers & 1) == 0 || (this.modifiers & 8) == 0)) {
                        throw new IllegalStateException("Cannot define a non-public, non-static field for " + instrumentedType);
                    }
                    return instrumentedType.withField(new FieldDescription.Token(this.name, this.modifiers, this.typeDescription));
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    FieldDefiner that = (FieldDefiner)other;
                    return this.modifiers == that.modifiers && this.name.equals(that.name) && this.typeDescription.equals(that.typeDescription);
                }

                public int hashCode() {
                    int result = this.name.hashCode();
                    result = 31 * result + this.typeDescription.hashCode();
                    result = 31 * result + this.modifiers;
                    return result;
                }

                public String toString() {
                    return "FieldAccessor.ForNamedField.PreparationHandler.FieldDefiner{name='" + this.name + '\'' + ", typeDescription=" + this.typeDescription + ", modifiers=" + this.modifiers + '}';
                }
            }

            public static enum NoOp implements PreparationHandler
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public String toString() {
                    return "FieldAccessor.ForNamedField.PreparationHandler.NoOp." + this.name();
                }
            }
        }
    }

    protected static class ForUnnamedField
    extends FieldAccessor
    implements OwnerTypeLocatable {
        private final FieldLocator.Factory fieldLocatorFactory;
        private final FieldNameExtractor fieldNameExtractor;

        protected ForUnnamedField(Assigner assigner, Assigner.Typing typing, FieldNameExtractor fieldNameExtractor) {
            this(assigner, typing, fieldNameExtractor, FieldLocator.ForInstrumentedTypeHierarchy.Factory.INSTANCE);
        }

        protected ForUnnamedField(Assigner assigner, Assigner.Typing typing, FieldNameExtractor fieldNameExtractor, FieldLocator.Factory fieldLocatorFactory) {
            super(assigner, typing);
            this.fieldNameExtractor = fieldNameExtractor;
            this.fieldLocatorFactory = fieldLocatorFactory;
        }

        @Override
        public AssignerConfigurable in(FieldLocator.Factory fieldLocatorFactory) {
            return new ForUnnamedField(this.assigner, this.typing, this.fieldNameExtractor, fieldLocatorFactory);
        }

        @Override
        public AssignerConfigurable in(Class<?> type) {
            return this.in(new TypeDescription.ForLoadedType(type));
        }

        @Override
        public AssignerConfigurable in(TypeDescription typeDescription) {
            return typeDescription.represents((Type)((Object)TargetType.class)) ? this.in(FieldLocator.ForInstrumentedType.INSTANCE) : this.in(new FieldLocator.ForGivenType.Factory(typeDescription));
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForUnnamedField(assigner, typing, this.fieldNameExtractor, this.fieldLocatorFactory);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(this.fieldLocatorFactory.make(implementationTarget.getInstrumentedType()));
        }

        @Override
        protected String getFieldName(MethodDescription targetMethod) {
            return this.fieldNameExtractor.fieldNameFor(targetMethod);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.fieldNameExtractor.equals(((ForUnnamedField)other).fieldNameExtractor) && this.fieldLocatorFactory.equals(((ForUnnamedField)other).fieldLocatorFactory);
        }

        @Override
        public int hashCode() {
            return 31 * (31 * super.hashCode() + this.fieldLocatorFactory.hashCode()) + this.fieldNameExtractor.hashCode();
        }

        public String toString() {
            return "FieldAccessor.ForUnnamedField{assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + ", fieldLocatorFactory=" + this.fieldLocatorFactory + ", fieldNameExtractor=" + this.fieldNameExtractor + '}';
        }
    }

    public static interface FieldDefinable
    extends OwnerTypeLocatable {
        public AssignerConfigurable defineAs(Type var1, ModifierContributor.ForField ... var2);

        public AssignerConfigurable defineAs(TypeDefinition var1, ModifierContributor.ForField ... var2);
    }

    public static interface OwnerTypeLocatable
    extends AssignerConfigurable {
        public AssignerConfigurable in(Class<?> var1);

        public AssignerConfigurable in(TypeDescription var1);

        public AssignerConfigurable in(FieldLocator.Factory var1);
    }

    public static interface AssignerConfigurable
    extends Implementation {
        public Implementation withAssigner(Assigner var1, Assigner.Typing var2);
    }

    public static interface FieldNameExtractor {
        public String fieldNameFor(MethodDescription var1);

        public static enum ForBeanProperty implements FieldNameExtractor
        {
            INSTANCE;


            @Override
            public String fieldNameFor(MethodDescription methodDescription) {
                int crop;
                String name = methodDescription.getInternalName();
                if (name.startsWith("get") || name.startsWith("set")) {
                    crop = 3;
                } else if (name.startsWith("is")) {
                    crop = 2;
                } else {
                    throw new IllegalArgumentException(methodDescription + " does not follow Java bean naming conventions");
                }
                name = name.substring(crop);
                if (name.length() == 0) {
                    throw new IllegalArgumentException(methodDescription + " does not specify a bean name");
                }
                return Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }

            public String toString() {
                return "FieldAccessor.FieldNameExtractor.ForBeanProperty." + this.name();
            }
        }
    }

    public static interface FieldLocator {
        public FieldDescription locate(String var1, boolean var2);

        public static class ForGivenType
        implements FieldLocator {
            private final TypeDescription targetType;
            private final TypeDescription instrumentedType;

            public ForGivenType(TypeDescription targetType, TypeDescription instrumentedType) {
                this.targetType = targetType;
                this.instrumentedType = instrumentedType;
            }

            @Override
            public FieldDescription locate(String name, boolean staticMethod) {
                FieldList fieldList = (FieldList)this.targetType.getDeclaredFields().filter(ElementMatchers.named(name).and(ElementMatchers.isVisibleTo(this.instrumentedType)));
                if (fieldList.size() > 1) {
                    throw new IllegalStateException("Ambiguous fields named '" + name + "' " + fieldList);
                }
                if (fieldList.isEmpty() || staticMethod && !((FieldDescription)fieldList.getOnly()).isStatic()) {
                    throw new IllegalArgumentException("No field named " + name + " on " + this.targetType + " is visible to " + this.instrumentedType);
                }
                return (FieldDescription)fieldList.getOnly();
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((ForGivenType)other).instrumentedType) && this.targetType.equals(((ForGivenType)other).targetType);
            }

            public int hashCode() {
                return 31 * this.instrumentedType.hashCode() + this.targetType.hashCode();
            }

            public String toString() {
                return "FieldAccessor.FieldLocator.ForGivenType{targetType=" + this.targetType + ", instrumentedType=" + this.instrumentedType + '}';
            }

            public static class Factory
            implements nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.FieldAccessor$FieldLocator$Factory {
                private final TypeDescription targetType;

                public Factory(TypeDescription targetType) {
                    this.targetType = targetType;
                }

                @Override
                public FieldLocator make(TypeDescription instrumentedType) {
                    return new ForGivenType(this.targetType, instrumentedType);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.targetType.equals(((Factory)other).targetType);
                }

                public int hashCode() {
                    return this.targetType.hashCode();
                }

                public String toString() {
                    return "FieldAccessor.FieldLocator.ForGivenType.Factory{targetType=" + this.targetType + '}';
                }
            }
        }

        public static class ForInstrumentedTypeHierarchy
        implements FieldLocator {
            private final TypeDescription instrumentedType;

            public ForInstrumentedTypeHierarchy(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public FieldDescription locate(String name, boolean staticMethod) {
                for (TypeDefinition currentType : this.instrumentedType) {
                    FieldList fieldList = (FieldList)currentType.getDeclaredFields().filter(ElementMatchers.named(name).and(ElementMatchers.isVisibleTo(this.instrumentedType)));
                    if (fieldList.size() > 1) {
                        throw new IllegalStateException("Ambiguous fields: " + fieldList);
                    }
                    if (fieldList.isEmpty() || staticMethod && !((FieldDescription)fieldList.getOnly()).isStatic()) continue;
                    return (FieldDescription)fieldList.getOnly();
                }
                throw new IllegalArgumentException("There is no field '" + name + " that is visible to " + this.instrumentedType);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((ForInstrumentedTypeHierarchy)other).instrumentedType);
            }

            public int hashCode() {
                return this.instrumentedType.hashCode();
            }

            public String toString() {
                return "FieldAccessor.FieldLocator.ForInstrumentedTypeHierarchy{instrumentedType=" + this.instrumentedType + '}';
            }

            public static enum Factory implements nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.FieldAccessor$FieldLocator$Factory
            {
                INSTANCE;


                @Override
                public FieldLocator make(TypeDescription instrumentedType) {
                    return new ForInstrumentedTypeHierarchy(instrumentedType);
                }

                public String toString() {
                    return "FieldAccessor.FieldLocator.ForInstrumentedTypeHierarchy.Factory." + this.name();
                }
            }
        }

        public static interface Factory {
            public FieldLocator make(TypeDescription var1);
        }

        public static enum ForInstrumentedType implements Factory
        {
            INSTANCE;


            @Override
            public FieldLocator make(TypeDescription instrumentedType) {
                return new ForGivenType(instrumentedType, instrumentedType);
            }

            public String toString() {
                return "FieldAccessor.FieldLocator.ForInstrumentedType." + this.name();
            }
        }
    }
}

