/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Iterator;
import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.ArgumentTypeResolver;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.MethodDelegationBinder;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation.RuntimeType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodVariableAccess;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Argument {
    public int value();

    public BindingMechanic bindingMechanic() default BindingMechanic.UNIQUE;

    public static enum NextUnboundAsDefaultsProvider implements TargetMethodAnnotationDrivenBinder.DefaultsProvider
    {
        INSTANCE;


        private static Iterator<Integer> makeFreeIndexList(MethodDescription source, MethodDescription target) {
            LinkedHashSet<Integer> results = new LinkedHashSet<Integer>(source.getParameters().size());
            for (int sourceIndex = 0; sourceIndex < source.getParameters().size(); ++sourceIndex) {
                results.add(sourceIndex);
            }
            for (ParameterDescription parameterDescription : target.getParameters()) {
                AnnotationDescription.Loadable<Argument> annotation = parameterDescription.getDeclaredAnnotations().ofType(Argument.class);
                if (annotation == null) continue;
                results.remove(annotation.loadSilent().value());
            }
            return results.iterator();
        }

        @Override
        public Iterator<AnnotationDescription> makeIterator(Implementation.Target implementationTarget, MethodDescription source, MethodDescription target) {
            return new NextUnboundArgumentIterator(NextUnboundAsDefaultsProvider.makeFreeIndexList(source, target));
        }

        public String toString() {
            return "Argument.NextUnboundAsDefaultsProvider." + this.name();
        }

        protected static class NextUnboundArgumentIterator
        implements Iterator<AnnotationDescription> {
            private final Iterator<Integer> iterator;

            protected NextUnboundArgumentIterator(Iterator<Integer> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public AnnotationDescription next() {
                return AnnotationDescription.ForLoadedAnnotation.of(new DefaultArgument(this.iterator.next()));
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }

            public String toString() {
                return "Argument.NextUnboundAsDefaultsProvider.NextUnboundArgumentIterator{iterator=" + this.iterator + '}';
            }

            protected static class DefaultArgument
            implements Argument {
                private static final String VALUE = "value";
                private static final String BINDING_MECHANIC = "bindingMechanic";
                private final int parameterIndex;

                protected DefaultArgument(int parameterIndex) {
                    this.parameterIndex = parameterIndex;
                }

                @Override
                public int value() {
                    return this.parameterIndex;
                }

                @Override
                public BindingMechanic bindingMechanic() {
                    return BindingMechanic.UNIQUE;
                }

                public Class<Argument> annotationType() {
                    return Argument.class;
                }

                @Override
                public boolean equals(Object other) {
                    return this == other || other instanceof Argument && this.parameterIndex == ((Argument)other).value();
                }

                @Override
                public int hashCode() {
                    return (127 * BINDING_MECHANIC.hashCode() ^ BindingMechanic.UNIQUE.hashCode()) + (127 * VALUE.hashCode() ^ this.parameterIndex);
                }

                @Override
                public String toString() {
                    return "@" + Argument.class.getName() + "(bindingMechanic=" + BindingMechanic.UNIQUE.toString() + ", value=" + this.parameterIndex + ")";
                }
            }
        }
    }

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Argument>
    {
        INSTANCE;


        @Override
        public Class<Argument> getHandledType() {
            return Argument.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Argument> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
            Argument argument = annotation.loadSilent();
            if (argument.value() < 0) {
                throw new IllegalArgumentException("@Argument annotation on " + target + " specifies negative index");
            }
            if (source.getParameters().size() <= argument.value()) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return argument.bindingMechanic().makeBinding(((ParameterDescription)source.getParameters().get(argument.value())).getType(), target.getType(), argument.value(), assigner, RuntimeType.Verifier.check(target), ((ParameterDescription)source.getParameters().get(argument.value())).getOffset());
        }

        public String toString() {
            return "Argument.Binder." + this.name();
        }
    }

    public static enum BindingMechanic {
        UNIQUE{

            @Override
            protected MethodDelegationBinder.ParameterBinding<?> makeBinding(TypeDescription.Generic source, TypeDescription.Generic target, int sourceParameterIndex, Assigner assigner, Assigner.Typing typing, int parameterOffset) {
                return MethodDelegationBinder.ParameterBinding.Unique.of(new StackManipulation.Compound(MethodVariableAccess.of(source).loadOffset(parameterOffset), assigner.assign(source, target, typing)), new ArgumentTypeResolver.ParameterIndexToken(sourceParameterIndex));
            }
        }
        ,
        ANONYMOUS{

            @Override
            protected MethodDelegationBinder.ParameterBinding<?> makeBinding(TypeDescription.Generic source, TypeDescription.Generic target, int sourceParameterIndex, Assigner assigner, Assigner.Typing typing, int parameterOffset) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(new StackManipulation.Compound(MethodVariableAccess.of(source).loadOffset(parameterOffset), assigner.assign(source, target, typing)));
            }
        };


        protected abstract MethodDelegationBinder.ParameterBinding<?> makeBinding(TypeDescription.Generic var1, TypeDescription.Generic var2, int var3, Assigner var4, Assigner.Typing var5, int var6);

        public String toString() {
            return "Argument.BindingMechanic." + this.name();
        }
    }
}

