/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatcher;

public class CollectionOneToOneMatcher<T>
extends ElementMatcher.Junction.AbstractBase<Iterable<? extends T>> {
    private final List<? extends ElementMatcher<? super T>> elementMatchers;

    public CollectionOneToOneMatcher(List<? extends ElementMatcher<? super T>> elementMatchers) {
        this.elementMatchers = elementMatchers;
    }

    @Override
    public boolean matches(Iterable<? extends T> target) {
        if (target instanceof Collection && ((Collection)target).size() != this.elementMatchers.size()) {
            return false;
        }
        Iterator<ElementMatcher<T>> iterator = this.elementMatchers.iterator();
        for (T value : target) {
            if (iterator.hasNext() && iterator.next().matches(value)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.elementMatchers.equals(((CollectionOneToOneMatcher)other).elementMatchers);
    }

    public int hashCode() {
        return this.elementMatchers.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("containing(");
        boolean first = true;
        for (ElementMatcher<? super T> elementMatcher : this.elementMatchers) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(elementMatcher);
        }
        return stringBuilder.append(")").toString();
    }
}

