/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.objenesis.instantiator.jrockit;

import java.lang.reflect.Method;
import nl.jqno.equalsverifier.internal.lib.objenesis.ObjenesisException;
import nl.jqno.equalsverifier.internal.lib.objenesis.instantiator.ObjectInstantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRockitLegacyInstantiator<T>
implements ObjectInstantiator<T> {
    private static Method safeAllocObjectMethod = null;
    private final Class<T> type;

    private static void initialize() {
        if (safeAllocObjectMethod == null) {
            try {
                Class<?> memSystem = Class.forName("jrockit.vm.MemSystem");
                safeAllocObjectMethod = memSystem.getDeclaredMethod("safeAllocObject", Class.class);
                safeAllocObjectMethod.setAccessible(true);
            }
            catch (RuntimeException e) {
                throw new ObjenesisException(e);
            }
            catch (ClassNotFoundException e) {
                throw new ObjenesisException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ObjenesisException(e);
            }
        }
    }

    public JRockitLegacyInstantiator(Class<T> type) {
        JRockitLegacyInstantiator.initialize();
        this.type = type;
    }

    @Override
    public T newInstance() {
        try {
            return this.type.cast(safeAllocObjectMethod.invoke(null, this.type));
        }
        catch (Exception e) {
            throw new ObjenesisException(e);
        }
    }
}

