/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InitServletTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletInitialization() throws Exception {
        Server server = new Server(0);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder(DemoServlet.class), "/*");
        HttpClient client = new HttpClient();
        server.addBean((Object)client);
        server.start();
        try {
            int port = ((NetworkConnector)server.getConnectors()[0]).getLocalPort();
            CountDownLatch resultsLatch = new CountDownLatch(2);
            int[] results = new int[2];
            AsyncResponseListener l = new AsyncResponseListener(resultsLatch, results);
            client.newRequest("http://localhost:" + port + "/r1").send((Response.CompleteListener)l);
            Thread.sleep(500L);
            client.newRequest("http://localhost:" + port + "/r2").send((Response.CompleteListener)l);
            Assertions.assertTrue((boolean)resultsLatch.await(4000L, TimeUnit.MILLISECONDS));
            Assertions.assertEquals((int)200, (int)results[0]);
            Assertions.assertEquals((int)200, (int)results[1]);
        }
        finally {
            server.stop();
        }
    }

    private static class AsyncResponseListener
    implements Response.CompleteListener {
        private final AtomicInteger index = new AtomicInteger();
        private final CountDownLatch resultsLatch;
        private final int[] results;

        public AsyncResponseListener(CountDownLatch resultsLatch, int[] results) {
            this.resultsLatch = resultsLatch;
            this.results = results;
        }

        public void onComplete(Result result) {
            this.results[this.index.getAndIncrement()] = result.getResponse().getStatus();
            this.resultsLatch.countDown();
        }
    }

    public static class DemoServlet
    extends HttpServlet {
        private static final long INIT_SLEEP = 2000L;
        private final AtomicInteger initCount = new AtomicInteger();

        public void init() throws ServletException {
            super.init();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new ServletException((Throwable)e);
            }
            this.initCount.incrementAndGet();
        }

        public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            if (this.initCount.get() != 1) {
                resp.sendError(500, "Servlet not initialized!");
            }
        }
    }
}

