/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.authentication.jwt;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableMap;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.Curve;
import java.io.Serializable;
import java.security.PrivateKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.UUID;
import org.mockserver.authentication.jwt.JWKGenerator;
import org.mockserver.keys.AsymmetricKeyConverter;
import org.mockserver.keys.AsymmetricKeyPair;
import org.mockserver.serialization.ObjectMapperFactory;

public class JWTGenerator {
    private final ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private final JWKGenerator jwkGenerator;
    private final AsymmetricKeyPair asymmetricKeyPair;

    public JWTGenerator(AsymmetricKeyPair asymmetricKeyPair) {
        this.asymmetricKeyPair = asymmetricKeyPair;
        this.jwkGenerator = new JWKGenerator();
    }

    public String generateJWT() {
        try {
            this.jwkGenerator.generateJWK(this.asymmetricKeyPair);
            Instant now = Instant.now();
            JWSObject jwt = new JWSObject(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(this.asymmetricKeyPair.getKeyId()).type(JOSEObjectType.JWT).build(), new Payload((Map)ImmutableMap.of((Object)"sub", (Object)UUID.randomUUID().toString(), (Object)"aud", (Object)"https://www.mock-server.com", (Object)"iss", (Object)"https://www.mock-server.com", (Object)"nbf", (Object)now.minus(4L, ChronoUnit.HOURS).getEpochSecond(), (Object)"exp", (Object)now.plus(4L, ChronoUnit.HOURS).getEpochSecond(), (Object)"iat", (Object)now.getEpochSecond())));
            RSASSASigner signer = new RSASSASigner(this.asymmetricKeyPair.getKeyPair().getPrivate());
            jwt.sign((JWSSigner)signer);
            return jwt.serialize();
        }
        catch (JOSEException e) {
            throw new RuntimeException("Error while generating JWT", e);
        }
    }

    public String signJWT(Map<String, Serializable> claims) {
        try {
            RSASSASigner signer;
            byte[] privateKeyBytes = this.asymmetricKeyPair.getKeyPair().getPrivate().getEncoded();
            switch (this.asymmetricKeyPair.getAlgorithm()) {
                case EC256_SHA256: {
                    signer = new ECDSASigner((PrivateKey)AsymmetricKeyConverter.getECPrivateKey(privateKeyBytes), Curve.P_256);
                    break;
                }
                case EC384_SHA384: {
                    signer = new ECDSASigner((PrivateKey)AsymmetricKeyConverter.getECPrivateKey(privateKeyBytes), Curve.P_384);
                    break;
                }
                case ECP512_SHA512: {
                    signer = new ECDSASigner((PrivateKey)AsymmetricKeyConverter.getECPrivateKey(privateKeyBytes), Curve.P_521);
                    break;
                }
                case RSA2048_SHA256: 
                case RSA3072_SHA384: 
                case RSA4096_SHA512: {
                    signer = new RSASSASigner((PrivateKey)AsymmetricKeyConverter.getRSAPrivateKey(privateKeyBytes));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Error invalid algorithm has been provided");
                }
            }
            JWSAlgorithm signingAlgorithm = JWSAlgorithm.parse((String)this.asymmetricKeyPair.getAlgorithm().getJwtAlgorithm());
            JWSObject jwt = new JWSObject(new JWSHeader.Builder(signingAlgorithm).keyID(this.asymmetricKeyPair.getKeyId()).build(), new Payload(this.objectWriter.writeValueAsString(claims)));
            jwt.sign((JWSSigner)signer);
            return jwt.serialize();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Exception signing JWT", throwable);
        }
    }
}

