/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.collections.ImmutableEntry;
import org.mockserver.collections.SubSetMatcher;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.model.KeyAndValue;
import org.mockserver.model.NottableString;

public class NottableStringHashMap {
    private final Map<NottableString, NottableString> backingMap = new LinkedHashMap<NottableString, NottableString>();
    private final RegexStringMatcher regexStringMatcher;

    public NottableStringHashMap(MockServerLogger mockServerLogger, boolean controlPlaneMatcher, List<? extends KeyAndValue> entries) {
        this.regexStringMatcher = new RegexStringMatcher(mockServerLogger, controlPlaneMatcher);
        for (KeyAndValue keyAndValue : entries) {
            this.put(keyAndValue.getName(), keyAndValue.getValue());
        }
    }

    @VisibleForTesting
    public NottableStringHashMap(MockServerLogger mockServerLogger, boolean controlPlaneMatcher, NottableString[] ... keyAndValues) {
        this.regexStringMatcher = new RegexStringMatcher(mockServerLogger, controlPlaneMatcher);
        for (NottableString[] keyAndValue : keyAndValues) {
            if (keyAndValue.length < 2) continue;
            this.put(keyAndValue[0], keyAndValue[1]);
        }
    }

    public boolean containsAll(NottableStringHashMap subset) {
        return SubSetMatcher.containsSubset(this.regexStringMatcher, subset.entryList(), this.entryList());
    }

    public boolean allKeysNotted() {
        for (NottableString key : this.backingMap.keySet()) {
            if (key.isNot()) continue;
            return false;
        }
        return true;
    }

    public boolean allKeysOptional() {
        for (NottableString key : this.backingMap.keySet()) {
            if (key.isOptional()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    private void put(NottableString key, NottableString value) {
        this.backingMap.put(key, value != null ? value : NottableString.string(""));
    }

    private List<ImmutableEntry> entryList() {
        if (!this.backingMap.isEmpty()) {
            ArrayList<ImmutableEntry> entrySet = new ArrayList<ImmutableEntry>();
            for (Map.Entry<NottableString, NottableString> entry : this.backingMap.entrySet()) {
                entrySet.add(ImmutableEntry.entry(this.regexStringMatcher, entry.getKey(), entry.getValue()));
            }
            return entrySet;
        }
        return Collections.emptyList();
    }
}

