/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.List;
import java.util.stream.Collectors;
import org.mockserver.character.Character;
import org.mockserver.model.Cookies;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequestModifier;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.model.Parameters;
import org.mockserver.serialization.Base64Converter;
import org.mockserver.serialization.java.CookieToJavaSerializer;
import org.mockserver.serialization.java.HeaderToJavaSerializer;
import org.mockserver.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.serialization.java.ParameterToJavaSerializer;
import org.mockserver.serialization.java.ToJavaSerializer;

public class HttpRequestModifierToJavaSerializer
implements ToJavaSerializer<HttpRequestModifier> {
    private final Base64Converter base64Converter = new Base64Converter();

    public String serialize(List<HttpRequestModifier> httpRequestModifiers) {
        StringBuilder output = new StringBuilder();
        for (HttpRequestModifier httpRequestModifier : httpRequestModifiers) {
            output.append(this.serialize(0, httpRequestModifier));
            output.append(";");
            output.append(Character.NEW_LINE);
        }
        return output.toString();
    }

    @Override
    public String serialize(int numberOfSpacesToIndent, HttpRequestModifier request) {
        StringBuffer output = new StringBuffer();
        if (request != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            output.append("requestModifier()");
            if (request.getPath() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withPath(\"").append(request.getPath().getRegex()).append("\",\"").append(request.getPath().getSubstitution()).append("\")");
            }
            if (request.getQueryStringParameters() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withQueryStringParameters(");
                this.outputQueryStringParameters(numberOfSpacesToIndent, output, (Parameters)request.getQueryStringParameters().getAdd());
                this.outputQueryStringParameters(numberOfSpacesToIndent, output, (Parameters)request.getQueryStringParameters().getReplace());
                this.outputList(numberOfSpacesToIndent, output, request.getQueryStringParameters().getRemove());
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(")");
            }
            if (request.getHeaders() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withHeaders(");
                this.outputHeaders(numberOfSpacesToIndent, output, (Headers)request.getHeaders().getAdd());
                this.outputHeaders(numberOfSpacesToIndent, output, (Headers)request.getHeaders().getReplace());
                this.outputList(numberOfSpacesToIndent, output, request.getHeaders().getRemove());
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(")");
            }
            if (request.getCookies() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withCookies(");
                this.outputCookies(numberOfSpacesToIndent, output, (Cookies)request.getCookies().getAdd());
                this.outputCookies(numberOfSpacesToIndent, output, (Cookies)request.getCookies().getReplace());
                this.outputList(numberOfSpacesToIndent, output, request.getCookies().getRemove());
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(")");
            }
        }
        return output.toString();
    }

    private void outputQueryStringParameters(int numberOfSpacesToIndent, StringBuffer output, Parameters parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("parameters(");
            this.appendObject(numberOfSpacesToIndent + 2, output, new ParameterToJavaSerializer(), parameters.getEntries());
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("),");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null,");
        }
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuffer output, Headers headers) {
        if (headers != null && !headers.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("headers(");
            this.appendObject(numberOfSpacesToIndent + 2, output, new HeaderToJavaSerializer(), headers.getEntries());
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("),");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null,");
        }
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuffer output, Cookies cookies) {
        if (cookies != null && !cookies.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("cookies(");
            this.appendObject(numberOfSpacesToIndent + 2, output, new CookieToJavaSerializer(), cookies.getEntries());
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("),");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null,");
        }
    }

    private void outputList(int numberOfSpacesToIndent, StringBuffer output, List<String> add) {
        if (add != null && !add.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("ImmutableList.of(").append(Joiner.on((String)",").join((Iterable)add.stream().map(s -> "\"" + s + "\"").collect(Collectors.toList()))).append(")");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null");
        }
    }

    private <T extends ObjectWithReflectiveEqualsHashCodeToString> void appendObject(int numberOfSpacesToIndent, StringBuffer output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent + 1, objects));
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

