/* THIS FILE IS AUTOGENERATED FROM MatchPattern.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_MATCHPATTERNBINDING_H_
#define DOM_MATCHPATTERNBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {

namespace dom {

struct MatchPatternOptionsAtoms;
struct NativePropertyHooks;
class OwningStringOrMatchPattern;
class ProtoAndIfaceCache;

} // namespace dom

namespace extensions {

class MatchPattern;
class MatchPatternSet;

} // namespace extensions

} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningStringOrMatchPattern& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningStringOrMatchPattern& aUnion);


struct MatchPatternOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mIgnorePath;
  MOZ_INIT_OUTSIDE_CTOR bool mRestrictSchemes;

  MatchPatternOptions();

  explicit inline MatchPatternOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MatchPatternOptions(MatchPatternOptions&& aOther) = default;

  explicit inline MatchPatternOptions(const MatchPatternOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  MatchPatternOptions&
  operator=(const MatchPatternOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, MatchPatternOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastMatchPatternOptions : public MatchPatternOptions
{
  inline FastMatchPatternOptions()
    : MatchPatternOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrMatchPattern : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eMatchPattern
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eMatchPattern = TypeOrUninit::eMatchPattern
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<NonNull<mozilla::extensions::MatchPattern> > mMatchPattern;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrMatchPattern(const StringOrMatchPattern&) = delete;
  StringOrMatchPattern& operator=(const StringOrMatchPattern&) = delete;
public:
  explicit inline StringOrMatchPattern()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrMatchPattern()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::extensions::MatchPattern>&
  RawSetAsMatchPattern()
  {
    if (mType == eMatchPattern) {
      return mValue.mMatchPattern.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMatchPattern;
    return mValue.mMatchPattern.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::extensions::MatchPattern>&
  SetAsMatchPattern()
  {
    if (mType == eMatchPattern) {
      return mValue.mMatchPattern.Value();
    }
    Uninit();
    mType = eMatchPattern;
    return mValue.mMatchPattern.SetValue();
  }

  inline bool
  IsMatchPattern() const
  {
    return mType == eMatchPattern;
  }

  inline NonNull<mozilla::extensions::MatchPattern>&
  GetAsMatchPattern()
  {
    MOZ_RELEASE_ASSERT(IsMatchPattern(), "Wrong type!");
    return mValue.mMatchPattern.Value();
  }

  inline mozilla::extensions::MatchPattern&
  GetAsMatchPattern() const
  {
    MOZ_RELEASE_ASSERT(IsMatchPattern(), "Wrong type!");
    return mValue.mMatchPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eMatchPattern: {
        DestroyMatchPattern();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToMatchPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMatchPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyMatchPattern()
  {
    MOZ_RELEASE_ASSERT(IsMatchPattern(), "Wrong type!");
    mValue.mMatchPattern.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrMatchPattern : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningStringOrMatchPattern& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eMatchPattern
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eMatchPattern = TypeOrUninit::eMatchPattern
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<OwningNonNull<mozilla::extensions::MatchPattern> > mMatchPattern;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrMatchPattern()
    : mType(eUninitialized)
  {
  }

  OwningStringOrMatchPattern(OwningStringOrMatchPattern&& aOther);

  explicit inline OwningStringOrMatchPattern(const OwningStringOrMatchPattern& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrMatchPattern()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::extensions::MatchPattern>&
  RawSetAsMatchPattern();

  [[nodiscard]] OwningNonNull<mozilla::extensions::MatchPattern>&
  SetAsMatchPattern();

  inline bool
  IsMatchPattern() const
  {
    return mType == eMatchPattern;
  }

  inline OwningNonNull<mozilla::extensions::MatchPattern>&
  GetAsMatchPattern()
  {
    MOZ_RELEASE_ASSERT(IsMatchPattern(), "Wrong type!");
    return mValue.mMatchPattern.Value();
  }

  inline OwningNonNull<mozilla::extensions::MatchPattern> const &
  GetAsMatchPattern() const
  {
    MOZ_RELEASE_ASSERT(IsMatchPattern(), "Wrong type!");
    return mValue.mMatchPattern.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrMatchPattern&
  operator=(OwningStringOrMatchPattern&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrMatchPattern&
  operator=(const OwningStringOrMatchPattern& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToMatchPattern(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMatchPattern(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyMatchPattern();
};


namespace MatchPattern_Binding {

  typedef mozilla::extensions::MatchPattern NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::extensions::MatchPattern* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::MatchPattern,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace MatchPattern_Binding



namespace MatchPatternSet_Binding {

  typedef mozilla::extensions::MatchPatternSet NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::extensions::MatchPatternSet* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::MatchPatternSet,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace MatchPatternSet_Binding



} // namespace mozilla::dom

#endif // DOM_MATCHPATTERNBINDING_H_
