// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanCrashesMetrics_h
#define mozilla_GleanCrashesMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace crash {
  /**
   * generated from crash.app_build
   * The build id of the application. This may differ from `client_info` because a main process crash may be reported later by a different (e.g. updated) client.
   */
  constexpr impl::StringMetric app_build(4694);

  /**
   * generated from crash.app_channel
   * The release channel of the application. This may differ from `client_info` because a main process crash may be reported later by a different (e.g. updated) client.
   */
  constexpr impl::StringMetric app_channel(4695);

  /**
   * generated from crash.app_display_version
   * The version of the application. This may differ from `client_info` because a main process crash may be reported later by a different (e.g. updated) client.
   */
  constexpr impl::StringMetric app_display_version(4696);

  /**
   * generated from crash.async_shutdown_timeout
   */
  using AsyncShutdownTimeoutObjectBrokenAddBlockers = nsTArray<nsCString>;


  struct AsyncShutdownTimeoutObject {
    Maybe<nsCString> phase;
    Maybe<nsCString> conditions;
    Maybe<AsyncShutdownTimeoutObjectBrokenAddBlockers> broken_add_blockers;
  };
  /**
   * Present when a shutdown blocker failed to respond within a reasonable amount of time.
   */
  constexpr impl::ObjectMetric<AsyncShutdownTimeoutObject, struct AsyncShutdownTimeoutObjectTag> async_shutdown_timeout(4697);

  /**
   * generated from crash.background_task_name
   * The name of the background task if launched as one.
   */
  constexpr impl::StringMetric background_task_name(4698);

  /**
   * generated from crash.compressed_store_size
   * Size (in bytes) of the compressed crash store JSON file.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CRASH_STORE_COMPRESSED_BYTES.
   */
  constexpr impl::MemoryDistributionMetric compressed_store_size(4699);

  /**
   * generated from crash.event_loop_nesting_level
   * Indicates the nesting level of the event loop.
   */
  constexpr impl::QuantityMetric event_loop_nesting_level(4700);

  /**
   * generated from crash.font_name
   * The font family name that is being loaded when the crash occurred.
   */
  constexpr impl::StringMetric font_name(4701);

  /**
   * generated from crash.gpu_process_launch
   * The number of times that the GPU process was launched.
   */
  constexpr impl::QuantityMetric gpu_process_launch(4702);

  /**
   * generated from crash.ipc_channel_error
   * The error reason for an ipc-based content crash.
   */
  constexpr impl::StringMetric ipc_channel_error(4703);

  /**
   * generated from crash.is_garbage_collecting
   * Indicates that the crash occurred while the garbage collector was running.
   */
  constexpr impl::BooleanMetric is_garbage_collecting(4704);

  /**
   * generated from crash.main_thread_runnable_name
   * Name of the currently executing `nsIRunnable` on the main thread. Nightly-only.
   */
  constexpr impl::StringMetric main_thread_runnable_name(4705);

  /**
   * generated from crash.minidump_sha256_hash
   * The SHA256 hash of the associated minidump file, if any.
   */
  constexpr impl::StringMetric minidump_sha256_hash(4706);

  /**
   * generated from crash.moz_crash_reason
   * Contains the string passed to `MOZ_CRASH()`.
   */
  constexpr impl::StringMetric moz_crash_reason(4707);

  /**
   * generated from crash.process_type
   * The type of process that experienced a crash. See the full list of options [here](https://firefox-source-docs.mozilla.org/toolkit/components/telemetry/data/crash-ping.html#process-types).
   */
  constexpr impl::StringMetric process_type(4708);

  /**
   * generated from crash.profiler_child_shutdown_phase
   * The shutdown phase of the profiler.
   */
  constexpr impl::StringMetric profiler_child_shutdown_phase(4709);

  /**
   * generated from crash.quota_manager_shutdown_timeout
   */
  using QuotaManagerShutdownTimeoutObject = nsTArray<nsCString>;
  /**
   * Contains a list of shutdown steps and status of the quota manager clients.
   */
  constexpr impl::ObjectMetric<QuotaManagerShutdownTimeoutObject, struct QuotaManagerShutdownTimeoutObjectTag> quota_manager_shutdown_timeout(4710);

  /**
   * generated from crash.remote_type
   * The type of the content process. See the full list of options [here](https://firefox-source-docs.mozilla.org/toolkit/components/telemetry/data/crash-ping.html#remote-process-types).
   */
  constexpr impl::StringMetric remote_type(4711);

  /**
   * generated from crash.shutdown_progress
   * The shutdown phase in which the crash occurred.
   */
  constexpr impl::StringMetric shutdown_progress(4712);

  /**
   * generated from crash.stack_traces
   */

  struct StackTracesObjectModulesItem {
    Maybe<nsCString> base_address;
    Maybe<nsCString> end_address;
    Maybe<nsCString> code_id;
    Maybe<nsCString> debug_file;
    Maybe<nsCString> debug_id;
    Maybe<nsCString> filename;
    Maybe<nsCString> version;
  };

  using StackTracesObjectModules = nsTArray<StackTracesObjectModulesItem>;


  struct StackTracesObjectThreadsItemFramesItem {
    Maybe<int64_t> module_index;
    Maybe<nsCString> ip;
    Maybe<nsCString> trust;
  };

  using StackTracesObjectThreadsItemFrames = nsTArray<StackTracesObjectThreadsItemFramesItem>;


  struct StackTracesObjectThreadsItem {
    Maybe<StackTracesObjectThreadsItemFrames> frames;
  };

  using StackTracesObjectThreads = nsTArray<StackTracesObjectThreadsItem>;


  struct StackTracesObject {
    Maybe<nsCString> error;
    Maybe<nsCString> crash_type;
    Maybe<nsCString> crash_address;
    Maybe<int64_t> crash_thread;
    Maybe<int64_t> main_module;
    Maybe<StackTracesObjectModules> modules;
    Maybe<StackTracesObjectThreads> threads;
  };
  /**
   * Stack trace and module information of the crashing process.
   */
  constexpr impl::ObjectMetric<StackTracesObject, struct StackTracesObjectTag> stack_traces(4713);

  /**
   * generated from crash.startup
   * If true, the crash occurred during process startup.
   */
  constexpr impl::BooleanMetric startup(4714);

  /**
   * generated from crash.submit_attempt
   */
  enum class SubmitAttemptLabel: uint16_t {
    eMainCrash = 0,
    eMainHang = 1,
    eContentCrash = 2,
    eContentHang = 3,
    ePluginCrash = 4,
    ePluginHang = 5,
    eGmpluginCrash = 6,
    eGmpluginHang = 7,
    eGpuCrash = 8,
    eGpuHang = 9,
    eVrCrash = 10,
    eVrHang = 11,
    eRddCrash = 12,
    eRddHang = 13,
    eSocketCrash = 14,
    eSocketHang = 15,
    eUtilityCrash = 16,
    eUtilityHang = 17,
    eSandboxbrokerCrash = 18,
    eSandboxbrokerHang = 19,
    eForkserverCrash = 20,
    eForkserverHang = 21,
    e__Other__,
  };
  /**
   * An attempt to submit a crash. Keyed on the CrashManager Crash.type.
   * This metric was generated to correspond to the Legacy Telemetry count histogram PROCESS_CRASH_SUBMIT_ATTEMPT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SubmitAttemptLabel> submit_attempt(4715);

  /**
   * generated from crash.submit_success
   * The submission status when main/plugin/content crashes are submitted. 1 is success, 0 is failure. Keyed on the CrashManager Crash.type.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram PROCESS_CRASH_SUBMIT_SUCCESS.
   */
  constexpr impl::DualLabeledCounterMetric submit_success(4716);

  /**
   * generated from crash.time
   * The time at which the crash occurred.
   */
  constexpr impl::DatetimeMetric time(4717);

  /**
   * generated from crash.utility_actors_name
   * List of IPC actor names running on a utility process instance (if the crashing process was a utility process).
   */
  constexpr impl::StringListMetric utility_actors_name(4718);
}

template <>
inline void impl::ObjectMetric<crash::AsyncShutdownTimeoutObject, crash::AsyncShutdownTimeoutObjectTag>::Set(const crash::AsyncShutdownTimeoutObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.phase.isSome()) {
      writer.StringProperty("phase", *(aObj.phase));
    }
    if (aObj.conditions.isSome()) {
      writer.StringProperty("conditions", *(aObj.conditions));
    }
    if (aObj.broken_add_blockers.isSome()) {
      writer.StartArrayProperty("broken_add_blockers");
      for (const auto& aobjBrokenAddBlockersItem: *aObj.broken_add_blockers) {
        writer.StringElement(aobjBrokenAddBlockersItem);

      }
      writer.EndArray();
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<crash::QuotaManagerShutdownTimeoutObject, crash::QuotaManagerShutdownTimeoutObjectTag>::Set(const crash::QuotaManagerShutdownTimeoutObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StringElement(aobjItem);

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<crash::StackTracesObject, crash::StackTracesObjectTag>::Set(const crash::StackTracesObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.error.isSome()) {
      writer.StringProperty("error", *(aObj.error));
    }
    if (aObj.crash_type.isSome()) {
      writer.StringProperty("crash_type", *(aObj.crash_type));
    }
    if (aObj.crash_address.isSome()) {
      writer.StringProperty("crash_address", *(aObj.crash_address));
    }
    if (aObj.crash_thread.isSome()) {
      writer.IntProperty("crash_thread", *(aObj.crash_thread));
    }
    if (aObj.main_module.isSome()) {
      writer.IntProperty("main_module", *(aObj.main_module));
    }
    if (aObj.modules.isSome()) {
      writer.StartArrayProperty("modules");
      for (const auto& aobjModulesItem: *aObj.modules) {
        writer.StartObjectElement();
        {
          if (aobjModulesItem.base_address.isSome()) {
            writer.StringProperty("base_address", *(aobjModulesItem.base_address));
          }
          if (aobjModulesItem.end_address.isSome()) {
            writer.StringProperty("end_address", *(aobjModulesItem.end_address));
          }
          if (aobjModulesItem.code_id.isSome()) {
            writer.StringProperty("code_id", *(aobjModulesItem.code_id));
          }
          if (aobjModulesItem.debug_file.isSome()) {
            writer.StringProperty("debug_file", *(aobjModulesItem.debug_file));
          }
          if (aobjModulesItem.debug_id.isSome()) {
            writer.StringProperty("debug_id", *(aobjModulesItem.debug_id));
          }
          if (aobjModulesItem.filename.isSome()) {
            writer.StringProperty("filename", *(aobjModulesItem.filename));
          }
          if (aobjModulesItem.version.isSome()) {
            writer.StringProperty("version", *(aobjModulesItem.version));
          }
        }
        writer.EndObject();

      }
      writer.EndArray();
    }
    if (aObj.threads.isSome()) {
      writer.StartArrayProperty("threads");
      for (const auto& aobjThreadsItem: *aObj.threads) {
        writer.StartObjectElement();
        {
          if (aobjThreadsItem.frames.isSome()) {
            writer.StartArrayProperty("frames");
            for (const auto& aobjthreadsitemFramesItem: *aobjThreadsItem.frames) {
              writer.StartObjectElement();
              {
                if (aobjthreadsitemFramesItem.module_index.isSome()) {
                  writer.IntProperty("module_index", *(aobjthreadsitemFramesItem.module_index));
                }
                if (aobjthreadsitemFramesItem.ip.isSome()) {
                  writer.StringProperty("ip", *(aobjthreadsitemFramesItem.ip));
                }
                if (aobjthreadsitemFramesItem.trust.isSome()) {
                  writer.StringProperty("trust", *(aobjthreadsitemFramesItem.trust));
                }
              }
              writer.EndObject();

            }
            writer.EndArray();
          }
        }
        writer.EndObject();

      }
      writer.EndArray();
    }
  }
  writer.EndObject();


  SetStr(json);
}

namespace crash_windows {
  /**
   * generated from crash.windows.error_reporting
   * Indicates if the crash was intercepted by the Windows Error Reporting runtime exception module.
   */
  constexpr impl::BooleanMetric error_reporting(4719);

  /**
   * generated from crash.windows.file_dialog_error_code
   * The HRESULT returned from a Win32 system call leading to termination of the file-dialog utility process. MozCrashReason is expected to provide context for the value.
   */
  constexpr impl::StringMetric file_dialog_error_code(4720);
}

namespace crash_submission {
  /**
   * generated from crash_submission.channel_status
   * Collecting XHR channel status on error code when statusCode == 0.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> channel_status(4721);

  /**
   * generated from crash_submission.collector_errors
   * Amount and error name reported when performing crash submission.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> collector_errors(4722);

  /**
   * generated from crash_submission.failure
   * Number of failed crash report submissions
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> failure(4723);

  /**
   * generated from crash_submission.failure_event
   */
  struct FailureEventExtra {
    mozilla::Maybe<nsCString> id;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (id) {
        extraKeys.AppendElement()->AssignASCII("id");
        extraValues.EmplaceBack(id.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A crash report failed to be submitted.
   */
  constexpr impl::EventMetric<FailureEventExtra> failure_event(4724);

  /**
   * generated from crash_submission.pending
   * Number of pending crash report submissions
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pending(4725);

  /**
   * generated from crash_submission.success
   * Number of successfull crash report submissions
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> success(4726);
}

namespace dll_blocklist {
  /**
   * generated from dll_blocklist.init_failed
   * Indicates whether initialization of the DLL blocklist failed.
   */
  constexpr impl::BooleanMetric init_failed(4727);

  /**
   * generated from dll_blocklist.list
   * A list of blocked DLLs.
   */
  constexpr impl::StringListMetric list(4728);

  /**
   * generated from dll_blocklist.user32_loaded_before
   * Indicates whether `user32.dll` was loaded before the DLL blocklist was initialized.
   */
  constexpr impl::BooleanMetric user32_loaded_before(4729);
}

namespace environment {
  /**
   * generated from environment.headless_mode
   * Whether the app was invoked in headless mode via `--headless` or `--backgroundtask`.
   */
  constexpr impl::BooleanMetric headless_mode(4730);

  /**
   * generated from environment.nimbus_enrollments
   * The active Nimbus experiments and rollouts, as well as their branches.
   */
  constexpr impl::StringListMetric nimbus_enrollments(4731);

  /**
   * generated from environment.uptime
   * The start time of the application.
   */
  constexpr impl::TimespanMetric uptime(4732);
}

namespace memory {
  /**
   * generated from memory.available_commit
   * Available commit size.
   */
  constexpr impl::QuantityMetric available_commit(4733);

  /**
   * generated from memory.available_physical
   * Available physical memory.
   */
  constexpr impl::QuantityMetric available_physical(4734);

  /**
   * generated from memory.available_swap
   * Available swap memory.
   */
  constexpr impl::QuantityMetric available_swap(4735);

  /**
   * generated from memory.available_virtual
   * Available virtual memory.
   */
  constexpr impl::QuantityMetric available_virtual(4736);

  /**
   * generated from memory.js_large_allocation_failure
   * A large allocation couldn't be satisfied: What was its state when the crash happened.
   */
  constexpr impl::StringMetric js_large_allocation_failure(4737);

  /**
   * generated from memory.js_out_of_memory
   * A small allocation couldn't be satisfied: What was its state when the crash happened.
   */
  constexpr impl::StringMetric js_out_of_memory(4738);

  /**
   * generated from memory.low_physical
   * The number of times the available memory tracker has detected that free physical memory is running low.
   */
  constexpr impl::QuantityMetric low_physical(4739);

  /**
   * generated from memory.oom_allocation_size
   * The size of the allocation that caused on OOM crash.
   */
  constexpr impl::QuantityMetric oom_allocation_size(4740);

  /**
   * generated from memory.purgeable_physical
   * The amount of memory that can be deallocated by the OS in case of memory pressure.
   */
  constexpr impl::QuantityMetric purgeable_physical(4741);

  /**
   * generated from memory.system_use_percentage
   * The percentage of memory in use.
   */
  constexpr impl::QuantityMetric system_use_percentage(4742);

  /**
   * generated from memory.texture
   * The amount of memory used in textures.
   */
  constexpr impl::QuantityMetric texture(4743);

  /**
   * generated from memory.total_page_file
   * The total page file size.
   */
  constexpr impl::QuantityMetric total_page_file(4744);

  /**
   * generated from memory.total_physical
   * The total physical memory.
   */
  constexpr impl::QuantityMetric total_physical(4745);

  /**
   * generated from memory.total_virtual
   * The total virtual memory.
   */
  constexpr impl::QuantityMetric total_virtual(4746);
}

namespace windows {
  /**
   * generated from windows.package_family_name
   * The Package Family Name of Firefox, if installed through an MSIX package.
   */
  constexpr impl::StringMetric package_family_name(4769);
}

} // namespace mozilla::glean

#endif // mozilla_GleanCrashesMetrics_h
