// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomWorkersMetrics_h
#define mozilla_GleanDomWorkersMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace workers {
  /**
   * generated from workers.dedicated_worker_spawn_gets_queued
   * Tracking whether a DedicatedWorker spawn gets queued due to hitting max workers per domain limit.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEDICATED_WORKER_SPAWN_GETS_QUEUED.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> dedicated_worker_spawn_gets_queued(3957);

  /**
   * generated from workers.service_worker_spawn_gets_queued
   * Tracking whether a ServiceWorker spawn gets queued due to hitting max workers per domain limit.
   * This metric was generated to correspond to the Legacy Telemetry count histogram SERVICE_WORKER_SPAWN_GETS_QUEUED.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> service_worker_spawn_gets_queued(3958);

  /**
   * generated from workers.shared_worker_spawn_gets_queued
   * Tracking whether a SharedWorker spawn gets queued due to hitting max workers per domain limit.
   * This metric was generated to correspond to the Legacy Telemetry count histogram SHARED_WORKER_SPAWN_GETS_QUEUED.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> shared_worker_spawn_gets_queued(3959);

  /**
   * generated from workers.sync_worker_operation
   * Tracking how long a Worker thread is blocked when a sync operation is executed on the main-thread.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SYNC_WORKER_OPERATION.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> sync_worker_operation(3960);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomWorkersMetrics_h
