// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanMlMetrics_h
#define mozilla_GleanMlMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace firefox_ai_runtime {
  /**
   * generated from firefox.ai.runtime.engine_creation_failure
   */
  struct EngineCreationFailureExtra {
    mozilla::Maybe<nsCString> engineid;
    mozilla::Maybe<nsCString> error;
    mozilla::Maybe<nsCString> featureid;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> modelid;
    mozilla::Maybe<nsCString> taskname;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (engineid) {
        extraKeys.AppendElement()->AssignASCII("engineId");
        extraValues.EmplaceBack(engineid.value());
      }
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      if (featureid) {
        extraKeys.AppendElement()->AssignASCII("featureId");
        extraValues.EmplaceBack(featureid.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (modelid) {
        extraKeys.AppendElement()->AssignASCII("modelId");
        extraValues.EmplaceBack(modelid.value());
      }
      if (taskname) {
        extraKeys.AppendElement()->AssignASCII("taskName");
        extraValues.EmplaceBack(taskname.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * An inference engine has failed to create
   */
  constexpr impl::EventMetric<EngineCreationFailureExtra> engine_creation_failure(5016);

  /**
   * generated from firefox.ai.runtime.engine_creation_success
   */
  enum class EngineCreationSuccessLabel: uint16_t {
    eAutofillMl = 0,
    ePdfjs = 1,
    eMlSuggestIntent = 2,
    eMlSuggestNer = 3,
    eAboutInference = 4,
    eWebextension = 5,
    eWllamapreview = 6,
    eDefaultEngine = 7,
    eSmartTabEmbeddingEngine = 8,
    eSmartTabTopicEngine = 9,
    eSmartIntent = 10,
    e__Other__,
  };
  /**
   * An inference engine was created
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, EngineCreationSuccessLabel> engine_creation_success(5017);

  /**
   * generated from firefox.ai.runtime.engine_creation_success_flow
   */
  struct EngineCreationSuccessFlowExtra {
    mozilla::Maybe<uint32_t> duration;
    mozilla::Maybe<nsCString> engineid;
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (duration) {
        extraKeys.AppendElement()->AssignASCII("duration");
        extraValues.AppendElement()->AppendInt(duration.value());
      }
      if (engineid) {
        extraKeys.AppendElement()->AssignASCII("engineId");
        extraValues.EmplaceBack(engineid.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records a successful engine creation within a tracked flow
   */
  constexpr impl::EventMetric<EngineCreationSuccessFlowExtra> engine_creation_success_flow(5018);

  /**
   * generated from firefox.ai.runtime.engine_run
   */
  struct EngineRunExtra {
    mozilla::Maybe<nsCString> backend;
    mozilla::Maybe<uint32_t> cores;
    mozilla::Maybe<uint32_t> cpuMilliseconds;
    mozilla::Maybe<uint32_t> cpuUtilization;
    mozilla::Maybe<nsCString> engineId;
    mozilla::Maybe<nsCString> featureId;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<uint32_t> memoryBytes;
    mozilla::Maybe<nsCString> modelId;
    mozilla::Maybe<uint32_t> wallMilliseconds;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (backend) {
        extraKeys.AppendElement()->AssignASCII("backend");
        extraValues.EmplaceBack(backend.value());
      }
      if (cores) {
        extraKeys.AppendElement()->AssignASCII("cores");
        extraValues.AppendElement()->AppendInt(cores.value());
      }
      if (cpuMilliseconds) {
        extraKeys.AppendElement()->AssignASCII("cpu_milliseconds");
        extraValues.AppendElement()->AppendInt(cpuMilliseconds.value());
      }
      if (cpuUtilization) {
        extraKeys.AppendElement()->AssignASCII("cpu_utilization");
        extraValues.AppendElement()->AppendInt(cpuUtilization.value());
      }
      if (engineId) {
        extraKeys.AppendElement()->AssignASCII("engine_id");
        extraValues.EmplaceBack(engineId.value());
      }
      if (featureId) {
        extraKeys.AppendElement()->AssignASCII("feature_id");
        extraValues.EmplaceBack(featureId.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (memoryBytes) {
        extraKeys.AppendElement()->AssignASCII("memory_bytes");
        extraValues.AppendElement()->AppendInt(memoryBytes.value());
      }
      if (modelId) {
        extraKeys.AppendElement()->AssignASCII("model_id");
        extraValues.EmplaceBack(modelId.value());
      }
      if (wallMilliseconds) {
        extraKeys.AppendElement()->AssignASCII("wall_milliseconds");
        extraValues.AppendElement()->AppendInt(wallMilliseconds.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The performance and memory characteristics of a single run of the inference engine.
   */
  constexpr impl::EventMetric<EngineRunExtra> engine_run(5019);

  /**
   * generated from firefox.ai.runtime.model_deletion
   */
  struct ModelDeletionExtra {
    mozilla::Maybe<nsCString> deletedby;
    mozilla::Maybe<nsCString> error;
    mozilla::Maybe<nsCString> modelid;
    mozilla::Maybe<nsCString> modelrevision;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (deletedby) {
        extraKeys.AppendElement()->AssignASCII("deletedBy");
        extraValues.EmplaceBack(deletedby.value());
      }
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      if (modelid) {
        extraKeys.AppendElement()->AssignASCII("modelId");
        extraValues.EmplaceBack(modelid.value());
      }
      if (modelrevision) {
        extraKeys.AppendElement()->AssignASCII("modelRevision");
        extraValues.EmplaceBack(modelrevision.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A model is deleted
   */
  constexpr impl::EventMetric<ModelDeletionExtra> model_deletion(5020);

  /**
   * generated from firefox.ai.runtime.model_download
   */
  struct ModelDownloadExtra {
    mozilla::Maybe<uint32_t> duration;
    mozilla::Maybe<nsCString> engineid;
    mozilla::Maybe<nsCString> error;
    mozilla::Maybe<nsCString> featureid;
    mozilla::Maybe<nsCString> modeldownloadid;
    mozilla::Maybe<nsCString> modelid;
    mozilla::Maybe<nsCString> modelrevision;
    mozilla::Maybe<nsCString> step;
    mozilla::Maybe<uint32_t> when;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (duration) {
        extraKeys.AppendElement()->AssignASCII("duration");
        extraValues.AppendElement()->AppendInt(duration.value());
      }
      if (engineid) {
        extraKeys.AppendElement()->AssignASCII("engineId");
        extraValues.EmplaceBack(engineid.value());
      }
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      if (featureid) {
        extraKeys.AppendElement()->AssignASCII("featureId");
        extraValues.EmplaceBack(featureid.value());
      }
      if (modeldownloadid) {
        extraKeys.AppendElement()->AssignASCII("modelDownloadId");
        extraValues.EmplaceBack(modeldownloadid.value());
      }
      if (modelid) {
        extraKeys.AppendElement()->AssignASCII("modelId");
        extraValues.EmplaceBack(modelid.value());
      }
      if (modelrevision) {
        extraKeys.AppendElement()->AssignASCII("modelRevision");
        extraValues.EmplaceBack(modelrevision.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.EmplaceBack(step.value());
      }
      if (when) {
        extraKeys.AppendElement()->AssignASCII("when");
        extraValues.AppendElement()->AppendInt(when.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A model is downloaded
   */
  constexpr impl::EventMetric<ModelDownloadExtra> model_download(5021);

  /**
   * generated from firefox.ai.runtime.run_inference_failure
   */
  struct RunInferenceFailureExtra {
    mozilla::Maybe<nsCString> engineid;
    mozilla::Maybe<nsCString> featureid;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> modelid;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (engineid) {
        extraKeys.AppendElement()->AssignASCII("engineId");
        extraValues.EmplaceBack(engineid.value());
      }
      if (featureid) {
        extraKeys.AppendElement()->AssignASCII("featureId");
        extraValues.EmplaceBack(featureid.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (modelid) {
        extraKeys.AppendElement()->AssignASCII("modelId");
        extraValues.EmplaceBack(modelid.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * An inference run has failed
   */
  constexpr impl::EventMetric<RunInferenceFailureExtra> run_inference_failure(5022);

  /**
   * generated from firefox.ai.runtime.run_inference_success
   */
  enum class RunInferenceSuccessLabel: uint16_t {
    eAutofillMl = 0,
    ePdfjs = 1,
    eMlSuggestIntent = 2,
    eMlSuggestNer = 3,
    eAboutInference = 4,
    eWebextension = 5,
    eWllamapreview = 6,
    eDefaultEngine = 7,
    eSmartTabEmbeddingEngine = 8,
    eSmartTabTopicEngine = 9,
    eSmartIntent = 10,
    e__Other__,
  };
  /**
   * An inference engine was created
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, RunInferenceSuccessLabel> run_inference_success(5023);

  /**
   * generated from firefox.ai.runtime.run_inference_success_flow
   */
  struct RunInferenceSuccessFlowExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<uint32_t> inferenceTime;
    mozilla::Maybe<uint32_t> tokenizingTime;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (inferenceTime) {
        extraKeys.AppendElement()->AssignASCII("inference_time");
        extraValues.AppendElement()->AppendInt(inferenceTime.value());
      }
      if (tokenizingTime) {
        extraKeys.AppendElement()->AssignASCII("tokenizing_time");
        extraValues.AppendElement()->AppendInt(tokenizingTime.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records a successful inference run within a tracked flow
   */
  constexpr impl::EventMetric<RunInferenceSuccessFlowExtra> run_inference_success_flow(5024);

  /**
   * generated from firefox.ai.runtime.session_end
   */
  struct SessionEndExtra {
    mozilla::Maybe<uint32_t> duration;
    mozilla::Maybe<nsCString> featureId;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> status;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (duration) {
        extraKeys.AppendElement()->AssignASCII("duration");
        extraValues.AppendElement()->AppendInt(duration.value());
      }
      if (featureId) {
        extraKeys.AppendElement()->AssignASCII("feature_id");
        extraValues.EmplaceBack(featureId.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Marks the end of an ML inference session or workflow. This event is recorded when the session completes successfully or is terminated.
   */
  constexpr impl::EventMetric<SessionEndExtra> session_end(5025);

  /**
   * generated from firefox.ai.runtime.session_start
   */
  struct SessionStartExtra {
    mozilla::Maybe<nsCString> featureId;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> interaction;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (featureId) {
        extraKeys.AppendElement()->AssignASCII("feature_id");
        extraValues.EmplaceBack(featureId.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (interaction) {
        extraKeys.AppendElement()->AssignASCII("interaction");
        extraValues.EmplaceBack(interaction.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Marks the beginning of an ML inference session or workflow.
   */
  constexpr impl::EventMetric<SessionStartExtra> session_start(5026);
}

namespace model_management {
  /**
   * generated from model_management.details_view
   */
  struct DetailsViewExtra {
    mozilla::Maybe<nsCString> extensionIds;
    mozilla::Maybe<nsCString> featureIds;
    mozilla::Maybe<nsCString> model;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (extensionIds) {
        extraKeys.AppendElement()->AssignASCII("extension_ids");
        extraValues.EmplaceBack(extensionIds.value());
      }
      if (featureIds) {
        extraKeys.AppendElement()->AssignASCII("feature_ids");
        extraValues.EmplaceBack(featureIds.value());
      }
      if (model) {
        extraKeys.AppendElement()->AssignASCII("model");
        extraValues.EmplaceBack(model.value());
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user views the screen with model details in the model management section in Add-ons Manager
   */
  constexpr impl::EventMetric<DetailsViewExtra> details_view(5027);

  /**
   * generated from model_management.list_item_manage
   */
  struct ListItemManageExtra {
    mozilla::Maybe<nsCString> extensionIds;
    mozilla::Maybe<nsCString> featureIds;
    mozilla::Maybe<nsCString> model;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (extensionIds) {
        extraKeys.AppendElement()->AssignASCII("extension_ids");
        extraValues.EmplaceBack(extensionIds.value());
      }
      if (featureIds) {
        extraKeys.AppendElement()->AssignASCII("feature_ids");
        extraValues.EmplaceBack(featureIds.value());
      }
      if (model) {
        extraKeys.AppendElement()->AssignASCII("model");
        extraValues.EmplaceBack(model.value());
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user clicks on Manage from the three
   * dots next to a model item
   */
  constexpr impl::EventMetric<ListItemManageExtra> list_item_manage(5028);

  /**
   * generated from model_management.list_view
   */
  struct ListViewExtra {
    mozilla::Maybe<uint32_t> models;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (models) {
        extraKeys.AppendElement()->AssignASCII("models");
        extraValues.AppendElement()->AppendInt(models.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user views the model management section in Add-ons Manager
   */
  constexpr impl::EventMetric<ListViewExtra> list_view(5029);

  /**
   * generated from model_management.model_card_link
   */
  struct ModelCardLinkExtra {
    mozilla::Maybe<nsCString> extensionIds;
    mozilla::Maybe<nsCString> featureIds;
    mozilla::Maybe<nsCString> model;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (extensionIds) {
        extraKeys.AppendElement()->AssignASCII("extension_ids");
        extraValues.EmplaceBack(extensionIds.value());
      }
      if (featureIds) {
        extraKeys.AppendElement()->AssignASCII("feature_ids");
        extraValues.EmplaceBack(featureIds.value());
      }
      if (model) {
        extraKeys.AppendElement()->AssignASCII("model");
        extraValues.EmplaceBack(model.value());
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user clicks the model card link in the model details
   */
  constexpr impl::EventMetric<ModelCardLinkExtra> model_card_link(5030);

  /**
   * generated from model_management.remove_confirmation
   */
  struct RemoveConfirmationExtra {
    mozilla::Maybe<nsCString> action;
    mozilla::Maybe<nsCString> extensionIds;
    mozilla::Maybe<nsCString> featureIds;
    mozilla::Maybe<nsCString> model;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (action) {
        extraKeys.AppendElement()->AssignASCII("action");
        extraValues.EmplaceBack(action.value());
      }
      if (extensionIds) {
        extraKeys.AppendElement()->AssignASCII("extension_ids");
        extraValues.EmplaceBack(extensionIds.value());
      }
      if (featureIds) {
        extraKeys.AppendElement()->AssignASCII("feature_ids");
        extraValues.EmplaceBack(featureIds.value());
      }
      if (model) {
        extraKeys.AppendElement()->AssignASCII("model");
        extraValues.EmplaceBack(model.value());
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user interacts with the
   * panel to confirm removal of model
   */
  constexpr impl::EventMetric<RemoveConfirmationExtra> remove_confirmation(5031);

  /**
   * generated from model_management.remove_initiated
   */
  struct RemoveInitiatedExtra {
    mozilla::Maybe<nsCString> extensionIds;
    mozilla::Maybe<nsCString> featureIds;
    mozilla::Maybe<uint32_t> lastInstall;
    mozilla::Maybe<uint32_t> lastUsed;
    mozilla::Maybe<nsCString> model;
    mozilla::Maybe<uint32_t> size;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (extensionIds) {
        extraKeys.AppendElement()->AssignASCII("extension_ids");
        extraValues.EmplaceBack(extensionIds.value());
      }
      if (featureIds) {
        extraKeys.AppendElement()->AssignASCII("feature_ids");
        extraValues.EmplaceBack(featureIds.value());
      }
      if (lastInstall) {
        extraKeys.AppendElement()->AssignASCII("last_install");
        extraValues.AppendElement()->AppendInt(lastInstall.value());
      }
      if (lastUsed) {
        extraKeys.AppendElement()->AssignASCII("last_used");
        extraValues.AppendElement()->AppendInt(lastUsed.value());
      }
      if (model) {
        extraKeys.AppendElement()->AssignASCII("model");
        extraValues.EmplaceBack(model.value());
      }
      if (size) {
        extraKeys.AppendElement()->AssignASCII("size");
        extraValues.AppendElement()->AppendInt(size.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user clicks on Remove from the three dots next to
   * a model item or the remove button from the model details page
   */
  constexpr impl::EventMetric<RemoveInitiatedExtra> remove_initiated(5032);
}

} // namespace mozilla::glean

#endif // mozilla_GleanMlMetrics_h
