// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanReportbrokensiteMetrics_h
#define mozilla_GleanReportbrokensiteMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace broken_site_report {
  /**
   * generated from broken_site_report.breakage_category
   * An optional select-box choice (options may eventually change)
   */
  constexpr impl::StringMetric breakage_category(5350);

  /**
   * generated from broken_site_report.description
   * An optional description of the site issue the user is experiencing. May contain PII.
   */
  constexpr impl::TextMetric description(5351);

  /**
   * generated from broken_site_report.url
   * The URL of the site being reported. May contain PII.
   */
  constexpr impl::UrlMetric url(5352);
}

namespace broken_site_report_browser_info {
  /**
   * generated from broken_site_report.browser_info.addons
   */

  struct AddonsObjectItem {
    Maybe<nsCString> id;
    Maybe<nsCString> name;
    Maybe<bool> temporary;
    Maybe<nsCString> version;
  };

  using AddonsObject = nsTArray<AddonsObjectItem>;
  /**
   * Active user-installed addons (not themes). List of objects with `id`, `name`, `temporary`, and `version`. For instance, `[{"id":"addon-name@email.org", "name":"My Addon", "temporary":false, "version":"0.1.0"}]`
   */
  constexpr impl::ObjectMetric<AddonsObject, struct AddonsObjectTag> addons(5353);

  /**
   * generated from broken_site_report.browser_info.experiments
   */

  struct ExperimentsObjectItem {
    Maybe<nsCString> branch;
    Maybe<nsCString> slug;
    Maybe<nsCString> kind;
  };

  using ExperimentsObject = nsTArray<ExperimentsObjectItem>;
  /**
   * Experiments in which the user is actively enrolled. List of objects with `branch`, `slug`, and `kind`. For instance, `[{"branch":"some-branch", "slug":"some-experiment", "kind":"nimbusExperiment"}]`
   */
  constexpr impl::ObjectMetric<ExperimentsObject, struct ExperimentsObjectTag> experiments(5354);
}

template <>
inline void impl::ObjectMetric<broken_site_report_browser_info::AddonsObject, broken_site_report_browser_info::AddonsObjectTag>::Set(const broken_site_report_browser_info::AddonsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.id.isSome()) {
          writer.StringProperty("id", *(aobjItem.id));
        }
        if (aobjItem.name.isSome()) {
          writer.StringProperty("name", *(aobjItem.name));
        }
        if (aobjItem.temporary.isSome()) {
          writer.BoolProperty("temporary", *(aobjItem.temporary));
        }
        if (aobjItem.version.isSome()) {
          writer.StringProperty("version", *(aobjItem.version));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<broken_site_report_browser_info::ExperimentsObject, broken_site_report_browser_info::ExperimentsObjectTag>::Set(const broken_site_report_browser_info::ExperimentsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.branch.isSome()) {
          writer.StringProperty("branch", *(aobjItem.branch));
        }
        if (aobjItem.slug.isSome()) {
          writer.StringProperty("slug", *(aobjItem.slug));
        }
        if (aobjItem.kind.isSome()) {
          writer.StringProperty("kind", *(aobjItem.kind));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

namespace broken_site_report_browser_info_app {
  /**
   * generated from broken_site_report.browser_info.app.default_locales
   * Locale strings, ie `["en-US", "en"]`
   */
  constexpr impl::StringListMetric default_locales(5355);

  /**
   * generated from broken_site_report.browser_info.app.default_useragent_string
   * The default user-agent string of the browser
   */
  constexpr impl::TextMetric default_useragent_string(5356);

  /**
   * generated from broken_site_report.browser_info.app.fission_enabled
   * Whether Fission is enabled
   */
  constexpr impl::BooleanMetric fission_enabled(5357);
}

namespace broken_site_report_browser_info_graphics {
  /**
   * generated from broken_site_report.browser_info.graphics.device_pixel_ratio
   * A decimal number
   */
  constexpr impl::StringMetric device_pixel_ratio(5358);

  /**
   * generated from broken_site_report.browser_info.graphics.devices_json
   * JSON array of objects with `vendorID` and `deviceID`. For instance, `[{"vendorID":"0x000", "deviceID":"0x001"}]`
   */
  constexpr impl::TextMetric devices_json(5359);

  /**
   * generated from broken_site_report.browser_info.graphics.drivers_json
   * JSON array of objects with `renderer` and `version`. For instance, `[{"renderer":"demo", "version":"0.2"}]`
   */
  constexpr impl::TextMetric drivers_json(5360);

  /**
   * generated from broken_site_report.browser_info.graphics.features_json
   * JSON object. For instance, `{"WEBRENDER":"available","WEBRENDER_PARTIAL":"disabled (User disabled via pref)"}`
   */
  constexpr impl::TextMetric features_json(5361);

  /**
   * generated from broken_site_report.browser_info.graphics.has_touch_screen
   * Whether a touch screen was detected
   */
  constexpr impl::BooleanMetric has_touch_screen(5362);

  /**
   * generated from broken_site_report.browser_info.graphics.monitors_json
   * JSON array of objects with `screenWidth`, 'screenHeight`, and `scale`. For instance, `[{"screenWidth":3584,"screenHeight":2240,"scale":2}]`
   */
  constexpr impl::TextMetric monitors_json(5363);
}

namespace broken_site_report_browser_info_prefs {
  /**
   * generated from broken_site_report.browser_info.prefs.cookie_behavior
   * Value of `network.cookie.cookieBehavior`
   */
  constexpr impl::QuantityMetric cookie_behavior(5364);

  /**
   * generated from broken_site_report.browser_info.prefs.forced_accelerated_layers
   * Value of `layers.acceleration_force.enabled`
   */
  constexpr impl::BooleanMetric forced_accelerated_layers(5365);

  /**
   * generated from broken_site_report.browser_info.prefs.global_privacy_control_enabled
   * Value of `privacy.globalprivacycontrol.enabled`
   */
  constexpr impl::BooleanMetric global_privacy_control_enabled(5366);

  /**
   * generated from broken_site_report.browser_info.prefs.installtrigger_enabled
   * Value of `extensions.InstallTrigger.enabled`
   */
  constexpr impl::BooleanMetric installtrigger_enabled(5367);

  /**
   * generated from broken_site_report.browser_info.prefs.opaque_response_blocking
   * Value of `browser.opaqueResponseBlocking`
   */
  constexpr impl::BooleanMetric opaque_response_blocking(5368);

  /**
   * generated from broken_site_report.browser_info.prefs.resist_fingerprinting_enabled
   * Value of `privacy.resistFingerprinting`
   */
  constexpr impl::BooleanMetric resist_fingerprinting_enabled(5369);

  /**
   * generated from broken_site_report.browser_info.prefs.software_webrender
   * Value of `gfx.webrender.software`
   */
  constexpr impl::BooleanMetric software_webrender(5370);

  /**
   * generated from broken_site_report.browser_info.prefs.third_party_cookie_blocking_enabled
   * Value of `network.cookie.cookieBehavior.optInPartitioning`
   */
  constexpr impl::BooleanMetric third_party_cookie_blocking_enabled(5371);

  /**
   * generated from broken_site_report.browser_info.prefs.third_party_cookie_blocking_enabled_in_pbm
   * Value of `network.cookie.cookieBehavior.optInPartitioning.pbmode`
   */
  constexpr impl::BooleanMetric third_party_cookie_blocking_enabled_in_pbm(5372);
}

namespace broken_site_report_browser_info_security {
  /**
   * generated from broken_site_report.browser_info.security.antispyware
   * Which antispyware software was reported on this system.
   */
  constexpr impl::StringListMetric antispyware(5373);

  /**
   * generated from broken_site_report.browser_info.security.antivirus
   * Which antivirus software was reported on this system.
   */
  constexpr impl::StringListMetric antivirus(5374);

  /**
   * generated from broken_site_report.browser_info.security.firewall
   * Which firewall software was reported on this system.
   */
  constexpr impl::StringListMetric firewall(5375);
}

namespace broken_site_report_browser_info_system {
  /**
   * generated from broken_site_report.browser_info.system.is_tablet
   * Whether the device is a tablet
   */
  constexpr impl::BooleanMetric is_tablet(5376);

  /**
   * generated from broken_site_report.browser_info.system.memory
   * How many mb of RAM is reported for the system
   */
  constexpr impl::QuantityMetric memory(5377);
}

namespace broken_site_report_tab_info {
  /**
   * generated from broken_site_report.tab_info.languages
   * The languages the site actually sees (may be overridden)
   */
  constexpr impl::StringListMetric languages(5378);

  /**
   * generated from broken_site_report.tab_info.useragent_string
   * The userAgent the site actually sees (may be overridden)
   */
  constexpr impl::TextMetric useragent_string(5379);
}

namespace broken_site_report_tab_info_antitracking {
  /**
   * generated from broken_site_report.tab_info.antitracking.block_list
   * Currently either `basic` or `strict`, may change in the future.
   */
  constexpr impl::StringMetric block_list(5380);

  /**
   * generated from broken_site_report.tab_info.antitracking.blocked_origins
   * List of origins which were blocked by antitracking.
   */
  constexpr impl::StringListMetric blocked_origins(5381);

  /**
   * generated from broken_site_report.tab_info.antitracking.btp_has_purged_site
   * Whether the site in the current tab has recently been purged by Bounce Tracking Protection.
   */
  constexpr impl::BooleanMetric btp_has_purged_site(5382);

  /**
   * generated from broken_site_report.tab_info.antitracking.etp_category
   * The current ETP category, either `standard`, `strict`, or `custom`.
   */
  constexpr impl::StringMetric etp_category(5383);

  /**
   * generated from broken_site_report.tab_info.antitracking.has_mixed_active_content_blocked
   * Whether the reported tab has any blocked mixed active content
   */
  constexpr impl::BooleanMetric has_mixed_active_content_blocked(5384);

  /**
   * generated from broken_site_report.tab_info.antitracking.has_mixed_display_content_blocked
   * Whether the reported tab has any blocked mixed display content
   */
  constexpr impl::BooleanMetric has_mixed_display_content_blocked(5385);

  /**
   * generated from broken_site_report.tab_info.antitracking.has_tracking_content_blocked
   * Whether the reported tab has any blocked tracking content
   */
  constexpr impl::BooleanMetric has_tracking_content_blocked(5386);

  /**
   * generated from broken_site_report.tab_info.antitracking.is_private_browsing
   * Whether the tab the user was on when reporting is in private browsing mode
   */
  constexpr impl::BooleanMetric is_private_browsing(5387);
}

namespace broken_site_report_tab_info_frameworks {
  /**
   * generated from broken_site_report.tab_info.frameworks.fastclick
   * Whether the FastClick web library was detected on the original tab.
   */
  constexpr impl::BooleanMetric fastclick(5388);

  /**
   * generated from broken_site_report.tab_info.frameworks.marfeel
   * Whether the Marfeel web framework was detected on the original tab.
   */
  constexpr impl::BooleanMetric marfeel(5389);

  /**
   * generated from broken_site_report.tab_info.frameworks.mobify
   * Whether the Mobify web framework was detected on the original tab.
   */
  constexpr impl::BooleanMetric mobify(5390);
}

namespace webcompatreporting {
  /**
   * generated from webcompatreporting.learn_more
   */
  /**
   * The user will be redirected to a SUMO article (https://support.mozilla.org/km/kb/report-breakage-due-blocking) to learn more about reporting a broken site.
   */
  constexpr impl::EventMetric<NoExtraKeys> learn_more(5391);

  /**
   * generated from webcompatreporting.opened
   */
  struct OpenedExtra {
    mozilla::Maybe<nsCString> source;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records the method for opening the webcompat reporting window.
   */
  constexpr impl::EventMetric<OpenedExtra> opened(5392);

  /**
   * generated from webcompatreporting.previewed
   */
  /**
   * The user clicked the report preview button.
   */
  constexpr impl::EventMetric<NoExtraKeys> previewed(5393);

  /**
   * generated from webcompatreporting.reason_dropdown
   */
  struct ReasonDropdownExtra {
    mozilla::Maybe<nsCString> setting;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (setting) {
        extraKeys.AppendElement()->AssignASCII("setting");
        extraValues.EmplaceBack(setting.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record whether the user has a dropdown enabled + whether the dropdown menu is optional or mandatory.
   */
  constexpr impl::EventMetric<ReasonDropdownExtra> reason_dropdown(5394);

  /**
   * generated from webcompatreporting.send
   */
  struct SendExtra {
    mozilla::Maybe<bool> sentWithBlockedTrackers;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sentWithBlockedTrackers) {
        extraKeys.AppendElement()->AssignASCII("sent_with_blocked_trackers");
        extraValues.AppendElement()->AssignASCII(sentWithBlockedTrackers.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user selects the Send button to submit webcompat report data.
   */
  constexpr impl::EventMetric<SendExtra> send(5395);

  /**
   * generated from webcompatreporting.send_more_info
   */
  /**
   * Recorded when a user clicks on the Send More Info link in the reporting UI The user will be redirected to webcompat.com to submit a more comprehensive report. (This is only enabled on beta/nightly/pre-release channels).
   */
  constexpr impl::EventMetric<NoExtraKeys> send_more_info(5396);
}

} // namespace mozilla::glean

#endif // mozilla_GleanReportbrokensiteMetrics_h
