// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanToolkitModulesGeckoMetrics_h
#define mozilla_GleanToolkitModulesGeckoMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace mozstorage {
  /**
   * generated from mozstorage.sqlitejsm_transaction_timeout
   * Collection of javascript modules that created a Sqlite.sys.mjs transaction taking too long and timing out. This can be used to identify and optimize those modules transactions. This metric was generated to correspond to the Legacy Telemetry scalar mozstorage.sqlitejsm_transaction_timeout.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> sqlitejsm_transaction_timeout(5873);
}

namespace region {
  /**
   * generated from region.fetch_result
   * Result of XHR request fetching the country-code. 0=SUCCESS, 1=SUCCESS_WITHOUT_DATA, 2=XHRTIMEOUT, 3=ERROR (rest reserved for finer-grained error codes later)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SEARCH_SERVICE_COUNTRY_FETCH_RESULT.
   */
  constexpr impl::CustomDistributionMetric fetch_result(5874);

  /**
   * generated from region.fetch_time
   * Time (ms) it takes to fetch the country code
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SEARCH_SERVICE_COUNTRY_FETCH_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric fetch_time(5875);

  /**
   * generated from region.home_region
   * Records the detected home region of the user. This is the general region of the user's machine.
   * If a machine moves location, there is a minimum 2-week delay before this will be updated.
   * See the [Region documentation](https://firefox-source-docs.mozilla.org/toolkit/modules/toolkit_modules/Region.html) for more information about updates.
   */
  constexpr impl::StringMetric home_region(5876);

  /**
   * generated from region.store_region_result
   */
  enum class StoreRegionResultLabel: uint16_t {
    eSetforrestofworld = 0,
    eSetforunitedstates = 1,
    eIgnoredunitedstatesincorrecttimezone = 2,
    e__Other__,
  };
  /**
   * Records if a detected region value was stored or ignored. A region might be ignored if it is the US but the set timezone is not the US.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, StoreRegionResultLabel> store_region_result(5877);
}

} // namespace mozilla::glean

#endif // mozilla_GleanToolkitModulesGeckoMetrics_h
