// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanToolkitMozappsDefaultagentMetrics_h
#define mozilla_GleanToolkitMozappsDefaultagentMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace defaultagent {
  /**
   * generated from defaultagent.days_since_last_app_launch
   * Number of days since the app last launched. Once this reaches 90 days, the installation will stop running the default browser agent.
   */
  constexpr impl::QuantityMetric days_since_last_app_launch(5891);
}

namespace notification {
  /**
   * generated from notification.action
   * The action that the user took in response to the notification. Possible values currently include the following: * “dismissed-by-timeout” * “dismissed-to-action-center” * “dismissed-by-button” * “dismissed-by-application-hidden” * “make-firefox-default-button” * “toast-clicked”
   * Many of the values correspond to buttons on the notification and should be pretty self explanatory, but a few are less so. * “dismissed-to-action-center” will be used if the user clicks the arrow in
   *   the top right corner of the notification to dismiss it to the
   *   action center.
   * * “dismissed-by-application-hidden” is provided because that is a method of
   *   dismissal that the notification API could give but, in practice, should
   *   never be seen.
   * * “dismissed-by-timeout” indicates that the user did not interact with the
   *   notification and it timed out.
   */
  constexpr impl::StringMetric action(5892);

  /**
   * generated from notification.show_success
   * Whether a notification was shown or not. Possible value include "shown" and "error".
   */
  constexpr impl::BooleanMetric show_success(5893);
}

namespace system {
  /**
   * generated from system.os_version
   * The current Windows OS version, usually as a dotted quad ("x.y.z.w") with Windows Update Build Revision (UBR), but potentially as a dotted triple ("x.y.z") without UBR.
   */
  constexpr impl::StringMetric os_version(5894);

  /**
   * generated from system.previous_os_version
   * The Windows OS version before it was changed to the current setting. The possible values are the same as for `system.os_version`.
   * The OS does not keep track of the previous OS version, so the agent records this information itself. That means that it will be inaccurate until the first time the default is changed after the agent task begins running. Before then, the value of `previous_os_version` will be the same as `os_version`.
   * This value is updated every time the Default Agent runs, so when the default browser is first changed the values for `os_version` and `previous_os_version` will be different. But on subsequent executions of the Default Agent, the two values will be the same.
   */
  constexpr impl::StringMetric previous_os_version(5895);
}

namespace system_default {
  /**
   * generated from system_default.browser
   * Which browser is currently set as the system default web browser. This is simply a string with the name of the browser binned to a fixed set of known browsers.
   * Possible values currently include the following (from [DefaultBrowser.cpp](https://searchfox.org/mozilla-central/source/toolkit/mozapps/defaultagent/DefaultBrowser.cpp)): * "error" * "" (unknown) * "firefox" * "chrome" * "edge" * "edge-chrome" * "ie" * "opera" * "brave" * "yandex" * "qq-browser" * "360-browser" * "sogou" * "duckduckgo"
   */
  constexpr impl::StringMetric browser(5903);

  /**
   * generated from system_default.pdf_handler
   * Which pdf handler is currently set as the system default handler. This is simply a string with the name of the handler binned to a fixed set of known handlers.
   * Possible values currently include the following (from [DefaultPDF.cpp](https://searchfox.org/mozilla-central/source/toolkit/mozapps/defaultagent/DefaultPDF.cpp)): * "Error" * "" (unknown) * "Firefox" * "Microsoft Edge" * "Google Chrome" * "Adobe Acrobat" * "WPS" * "Nitro" * "Foxit" * "PDF-XChange" * "Avast" * "Sumatra"
   */
  constexpr impl::StringMetric pdf_handler(5904);

  /**
   * generated from system_default.previous_browser
   * Which browser was set as the system default before it was changed to the current setting. The possible values are the same as for `system_default.browser`.
   * The OS does not keep track of previous default settings, so the agent records this information itself. That means that it will be inaccurate until the first time the default is changed after the agent task begins running. Before then, the value of `previous_browser` will be the same as `browser`.
   * This value is updated every time the Default Agent runs, so when the default browser is first changed the values for `browser` and `previous_browser` will be different. But on subsequent executions of the Default Agent, the two values will be the same.
   */
  constexpr impl::StringMetric previous_browser(5905);
}

} // namespace mozilla::glean

#endif // mozilla_GleanToolkitMozappsDefaultagentMetrics_h
